/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVExport;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CSVExportTest
extends TestCase {
    List<Object> line = new ArrayList<Object>();

    public void testBasic() throws Exception {
        this.line.add("123");
        this.line.add(42);
        this.line.add("\"Hello, world\"");
        this.line.add("foo");
        String result = CSVExport.toString(this.line);
        System.out.println(result);
        CSVExportTest.assertEquals((String)"123,42,\"Hello, world\",foo", (String)result);
    }

    public void testQuoted() throws Exception {
        this.line = new ArrayList<Object>();
        this.line.add(123);
        this.line.add("\"Hello, \\\"ian\\\"\"");
        String result = CSVExport.toString(this.line);
        System.out.println(result);
        CSVExportTest.assertEquals((String)"123,\"Hello, \\\"ian\\\"\"", (String)result);
        this.line.clear();
        this.line.add("123,456.7");
        result = CSVExport.toString(this.line);
        CSVExportTest.assertEquals((String)"\"123,456.7\"", (String)result);
        this.line.clear();
        this.line.add(123);
        this.line.add("\"\"");
        CSVExportTest.assertEquals((String)"quote at end", (String)"123,\"\"", (String)CSVExport.toString(this.line));
    }

    public void testNullField() throws Exception {
        this.line = new ArrayList<Object>();
        this.line.add(123);
        this.line.add(null);
        this.line.add(456);
        String result = CSVExport.toString(this.line);
        System.out.println(result);
        CSVExportTest.assertEquals((String)"123,\"\",456", (String)result);
    }
}

