/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLSecurityManager;
import ca.sqlpower.security.PLUser;
import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.SQL;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PLGroup
implements DatabaseObject,
Serializable {
    protected boolean _alreadyInDatabase = false;
    protected String groupName;
    protected String groupDesc;
    protected Date lastUpdateDate;
    protected String lastUpdateUser;
    protected String lastUpdateOsUser;
    protected Date createDate;
    public static final String ADMIN_GROUP = "PL_ADMIN";
    public static final String OMNISCIENT_GROUP_NAME = "PL_SUPERUSER";

    protected PLGroup() {
    }

    public PLGroup(String groupName) {
        this();
        this.groupName = groupName;
    }

    public void storeNoCommit(Connection con) throws SQLException {
        Statement stmt = null;
        stmt = con.createStatement();
        StringBuffer sql = new StringBuffer();
        if (this._alreadyInDatabase) {
            sql.append("UPDATE pl_group");
            sql.append(" SET group_desc=").append(SQL.quote(this.getGroupDesc()));
            sql.append(", last_update_date=").append(DBConnection.getSystemDate(con));
            sql.append(", last_update_user=").append(SQL.quote(DBConnection.getUser(con).toUpperCase()));
            sql.append(", last_update_os_user='Power*Dashboard Web Frontend'");
            sql.append(" WHERE group_name = ").append(SQL.quote(this.getGroupName()));
            stmt.executeUpdate(sql.toString());
        } else {
            sql.append("INSERT INTO pl_group(");
            sql.append(" group_name, group_desc, last_update_date,");
            sql.append(" last_update_user, last_update_os_user, create_date)");
            sql.append(" VALUES( ");
            sql.append(SQL.quote(this.groupName.toUpperCase())).append(",");
            sql.append(SQL.quote(this.groupDesc)).append(",");
            sql.append(DBConnection.getSystemDate(con)).append(",");
            sql.append(SQL.quote(DBConnection.getUser(con).toUpperCase())).append(",");
            sql.append("'Power*Dashboard Web Frontend'").append(",");
            sql.append(DBConnection.getSystemDate(con)).append(")");
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("INSERT INTO group_object_privs(");
            sql.append("group_name,");
            sql.append("object_type, object_name,");
            sql.append("modify_ind, delete_ind, execute_ind, grant_ind,");
            sql.append("last_update_date, last_update_user)");
            sql.append(" VALUES(");
            sql.append(SQL.quote(this.groupName.toUpperCase())).append(",");
            sql.append("'GROUP', ").append(SQL.quote(this.groupName).toUpperCase()).append(",");
            sql.append("'Y', 'Y', 'Y', 'Y',");
            sql.append(DBConnection.getSystemDate(con)).append(",");
            sql.append(SQL.quote(DBConnection.getUser(con).toUpperCase())).append(")");
            stmt.executeUpdate(sql.toString());
            this._alreadyInDatabase = true;
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    public void store(Connection con) throws SQLException {
        boolean oldACVal = con.getAutoCommit();
        try {
            con.setAutoCommit(false);
            this.storeNoCommit(con);
            con.commit();
        }
        catch (SQLException e) {
            System.out.println("PLGroup: caught " + e);
            e.printStackTrace();
            con.rollback();
            throw e;
        }
        finally {
            con.setAutoCommit(oldACVal);
        }
    }

    public static PLGroup findByPrimaryKey(Connection con, String groupName) throws SQLException {
        List oneGroup = PLGroup.find(con, groupName, null, false, null);
        return (PLGroup)oneGroup.get(0);
    }

    public static List findByUser(Connection con, PLUser user) throws SQLException {
        return PLGroup.find(con, null, user.getUserId(), false, user.getGroupNameFilter());
    }

    public static List findAll(Connection con) throws SQLException {
        return PLGroup.find(con, null, null, false, null);
    }

    public static List findByPrefix(Connection con, String nameStartsWith) throws SQLException {
        return PLGroup.find(con, nameStartsWith, null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List find(Connection con, String groupName, String userName, boolean searchByPrefix, Set filter) throws SQLException {
        if (groupName != null && userName != null) {
            throw new IllegalArgumentException("Cannot specify both userName and groupName");
        }
        if (userName == null && filter != null) {
            throw new IllegalArgumentException("filter is not allowed unless non-null userName is specified");
        }
        LinkedList<PLGroup> results = new LinkedList<PLGroup>();
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer(500);
            sql.append("SELECT g.group_name, g.group_desc, g.last_update_date,");
            sql.append(" g.last_update_user, g.last_update_os_user, g.create_date");
            if (groupName != null) {
                sql.append(" FROM pl_group g");
                if (searchByPrefix) {
                    sql.append(" WHERE g.group_name LIKE ").append(SQL.quote(groupName + "%"));
                } else {
                    sql.append(" WHERE g.group_name=").append(SQL.quote(groupName));
                }
            } else if (userName != null) {
                sql.append(" FROM pl_group g, user_group ug");
                sql.append(" WHERE g.group_name = ug.group_name");
                if (searchByPrefix) {
                    sql.append(" AND ug.user_id LIKE ").append(SQL.quote(userName + "%"));
                } else {
                    sql.append(" AND ug.user_id=").append(SQL.quote(userName));
                }
                if (filter != null) {
                    sql.append(" AND g.group_name IN(").append(SQL.quoteCollection(filter)).append(")");
                }
            } else {
                sql.append(" FROM pl_group g");
            }
            sql.append(" ORDER BY g.group_name");
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            boolean hasRows = rs.next();
            if (!hasRows && groupName != null) {
                throw new IllegalArgumentException("No such group '" + groupName + "'");
            }
            if (!hasRows) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            do {
                PLGroup newBean = new PLGroup();
                newBean.groupName = rs.getString("group_name");
                newBean.groupDesc = rs.getString("group_desc");
                newBean.lastUpdateDate = rs.getDate("last_update_date");
                newBean.lastUpdateUser = rs.getString("last_update_user");
                newBean.lastUpdateOsUser = rs.getString("last_update_os_user");
                newBean.createDate = rs.getDate("create_date");
                newBean._alreadyInDatabase = true;
                results.add(newBean);
            } while (rs.next());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        if (groupName != null && !searchByPrefix && results.size() > 1) {
            throw new IllegalStateException("Got more than one result for group " + groupName);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMemberNames(Connection con) throws SQLException {
        StringBuffer sql = new StringBuffer(100);
        sql.append("SELECT user_id FROM user_group");
        sql.append(" WHERE group_name=").append(SQL.quote(this.getGroupName()));
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            LinkedList<String> members = new LinkedList<String>();
            while (rs.next()) {
                members.add(rs.getString(1));
            }
            LinkedList<String> linkedList = members;
            return linkedList;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(Connection con, PLSecurityManager secContext, String newUserId) throws SQLException, PLSecurityException {
        secContext.checkModify(con, this);
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer(200);
            sql.append("INSERT INTO user_group (user_id");
            sql.append(", group_name, last_update_date, last_update_user");
            sql.append(", last_update_os_user, create_date");
            sql.append(") VALUES (").append(SQL.quote(newUserId));
            sql.append(", ").append(SQL.quote(this.getGroupName()));
            sql.append(", ").append(DBConnection.getSystemDate(con));
            sql.append(", ").append(SQL.quote(secContext.getPrincipal().getUserName()));
            sql.append(", 'Power*Dashboard Web Facility'");
            sql.append(", ").append(DBConnection.getSystemDate(con));
            sql.append(")");
            stmt = con.createStatement();
            int updateCount = stmt.executeUpdate(sql.toString());
            if (updateCount != 1) {
                throw new IllegalStateException("Insert statement affected " + updateCount + " rows; should have been 1");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Connection con, PLSecurityManager secContext, String removeUserId) throws SQLException, PLSecurityException {
        secContext.checkModify(con, this);
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer(100);
            sql.append("DELETE FROM user_group");
            sql.append(" WHERE group_name=").append(SQL.quote(this.getGroupName()));
            if (removeUserId != null) {
                sql.append(" AND user_id=").append(SQL.quote(removeUserId));
            }
            stmt = con.createStatement();
            int updateCount = stmt.executeUpdate(sql.toString());
            if (removeUserId != null && updateCount != 1) {
                throw new IllegalStateException("Delete statement for group " + this.getGroupName() + " and user " + removeUserId + " affected " + updateCount + " rows; should have been 1");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public boolean isAdminGroup() {
        return this._alreadyInDatabase && this.groupName.equals(ADMIN_GROUP);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String argGroupName) {
        this.groupName = argGroupName;
    }

    public String getGroupDesc() {
        return this.groupDesc;
    }

    public void setGroupDesc(String argGroupDesc) {
        this.groupDesc = argGroupDesc;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public String getLastUpdateOsUser() {
        return this.lastUpdateOsUser;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String getObjectType() {
        return "GROUP";
    }

    public String getObjectName() {
        return this.getGroupName();
    }

    public String toString() {
        StringBuffer meString = new StringBuffer();
        meString.append("[Group: ");
        meString.append("groupName=").append(this.groupName).append(", ");
        meString.append("groupDesc=").append(this.groupDesc).append(", ");
        meString.append("lastUpdateDate=").append(this.lastUpdateDate).append(", ");
        meString.append("lastUpdateUser=").append(this.lastUpdateUser).append(", ");
        meString.append("lastUpdateOsUser=").append(this.lastUpdateOsUser).append(", ");
        meString.append("createDate=").append(this.createDate).append("]");
        return meString.toString();
    }
}

