/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.operations.CheckoutAsProjectOperation;
import org.tigris.subversion.subclipse.ui.util.IPromptCondition;
import org.tigris.subversion.subclipse.ui.util.PromptingDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutAsProjectAction
extends WorkspaceAction {
    protected IProject[] localFolders;
    protected ISVNRemoteFolder[] remoteFolders;
    protected IResource[] projects;
    protected boolean proceed;
    private ISVNRemoteFolder[] selectedFolders;
    private String projectName;
    private SVNRevision svnRevision = SVNRevision.HEAD;

    public CheckoutAsProjectAction() {
    }

    public CheckoutAsProjectAction(ISVNRemoteFolder[] selectedFolders, String projectName, Shell shell) {
        this.selectedFolders = selectedFolders;
        this.projectName = projectName;
        this.shell = shell;
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (!WorkspacePathValidator.validateWorkspacePath()) {
            return;
        }
        this.checkoutSelectionIntoWorkspaceDirectory();
    }

    protected void checkoutSelectionIntoWorkspaceDirectory() throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                block12: {
                    block11: {
                        try {
                            try {
                                block9: {
                                    int i;
                                    HashMap<String, ISVNRemoteFolder> targetFolders;
                                    block10: {
                                        ISVNRemoteFolder[] folders = CheckoutAsProjectAction.this.getSelectedRemoteFolders();
                                        ArrayList<IProject> targetProjects = new ArrayList<IProject>();
                                        targetFolders = new HashMap<String, ISVNRemoteFolder>();
                                        monitor.beginTask(null, 100);
                                        int i2 = 0;
                                        while (true) {
                                            if (i2 >= folders.length) {
                                                CheckoutAsProjectAction.this.projects = targetProjects.toArray(new IResource[targetProjects.size()]);
                                                PromptingDialog prompt = new PromptingDialog(CheckoutAsProjectAction.this.getShell(), CheckoutAsProjectAction.this.projects, CheckoutAsProjectAction.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
                                                CheckoutAsProjectAction.this.projects = prompt.promptForMultiple();
                                                if (CheckoutAsProjectAction.this.projects.length == 0) break block9;
                                                CheckoutAsProjectAction.this.localFolders = new IProject[CheckoutAsProjectAction.this.projects.length];
                                                CheckoutAsProjectAction.this.remoteFolders = new ISVNRemoteFolder[CheckoutAsProjectAction.this.projects.length];
                                                i = 0;
                                                break block10;
                                            }
                                            CheckoutAsProjectAction.this.proceed = true;
                                            if (folders[i2].getRepository().getRepositoryRoot().toString().equals(folders[i2].getUrl().toString())) {
                                                CheckoutAsProjectAction.this.shell.getDisplay().syncExec(new Runnable(this){
                                                    final /* synthetic */ 1 this$1;
                                                    {
                                                        this.this$1 = var1_1;
                                                    }

                                                    public void run() {
                                                        1.access$0(this.this$1).proceed = MessageDialog.openQuestion((Shell)CheckoutAsProjectAction.access$0(1.access$0(this.this$1)), (String)Policy.bind("CheckoutAsProjectAction.title"), (String)Policy.bind("AddToWorkspaceAction.checkingOutRoot"));
                                                    }
                                                });
                                            }
                                            if (!CheckoutAsProjectAction.this.proceed) break;
                                            IProject project = CheckoutAsProjectAction.this.projectName == null ? SVNWorkspaceRoot.getProject((ISVNRemoteFolder)folders[i2], (IProgressMonitor)monitor) : ResourcesPlugin.getWorkspace().getRoot().getProject(CheckoutAsProjectAction.this.projectName);
                                            targetFolders.put(project.getName(), folders[i2]);
                                            targetProjects.add(project);
                                            ++i2;
                                        }
                                        Object var7_10 = null;
                                        break block11;
                                    }
                                    while (i < CheckoutAsProjectAction.this.projects.length) {
                                        CheckoutAsProjectAction.this.localFolders[i] = (IProject)CheckoutAsProjectAction.this.projects[i];
                                        CheckoutAsProjectAction.this.remoteFolders[i] = (ISVNRemoteFolder)targetFolders.get(CheckoutAsProjectAction.this.projects[i].getName());
                                        ++i;
                                    }
                                    break block12;
                                }
                                CheckoutAsProjectAction.this.proceed = false;
                                break block12;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var7_12 = null;
                monitor.done();
            }

            static /* synthetic */ CheckoutAsProjectAction access$0(1 var0) {
                return var0.CheckoutAsProjectAction.this;
            }
        }, true, 1);
        if (this.proceed) {
            CheckoutAsProjectOperation checkoutAsProjectOperation = new CheckoutAsProjectOperation(this.getTargetPart(), this.remoteFolders, this.localFolders);
            checkoutAsProjectOperation.setSvnRevision(this.svnRevision);
            checkoutAsProjectOperation.run();
        }
    }

    protected boolean isEnabled() {
        ISVNRemoteFolder[] resources = this.getSelectedRemoteFolders();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof ISVNRepositoryLocation) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String getErrorTitle() {
        return Policy.bind("AddToWorkspaceAction.checkoutFailed");
    }

    protected static String getTaskName(ISVNRemoteFolder[] remoteFolders) {
        if (remoteFolders.length == 1) {
            ISVNRemoteFolder folder = remoteFolders[0];
            String label = folder.getRepositoryRelativePath();
            return Policy.bind("AddToWorkspace.taskName1", label);
        }
        return Policy.bind("AddToWorkspace.taskNameN", new Integer(remoteFolders.length).toString());
    }

    public static IPromptCondition getOverwriteLocalAndFileSystemPrompt() {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                File localLocation = this.getFileLocation(resource);
                return resource.exists() || localLocation.exists();
            }

            public String promptMessage(IResource resource) {
                this.getFileLocation(resource);
                if (resource.exists()) {
                    return Policy.bind("AddToWorkspaceAction.thisResourceExists", resource.getName());
                }
                return Policy.bind("AddToWorkspaceAction.thisExternalFileExists", resource.getName());
            }

            private File getFileLocation(IResource resource) {
                return new File(resource.getParent().getLocation().toFile(), resource.getName());
            }
        };
    }

    protected ISVNRemoteFolder[] getSelectedRemoteFolders() {
        if (this.selectedFolders != null) {
            return this.selectedFolders;
        }
        return super.getSelectedRemoteFolders();
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }
}

