/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.operations.ShowAnnotationOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class AnnotateDialog
extends TrayDialog {
    private IWorkbenchPart targetPart;
    private ISVNRemoteFile remoteFile;
    private Text fromRevisionText;
    private Button fromLogButton;
    private Button headButton;
    private Button revisionButton;
    private Text toRevisionText;
    private Button toLogButton;
    private Button okButton;
    private boolean success;

    public AnnotateDialog(Shell parentShell, IWorkbenchPart targetPart, ISVNRemoteFile remoteFile) {
        super(parentShell);
        this.remoteFile = remoteFile;
        this.targetPart = targetPart;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("AnnotateDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite urlGroup = new Composite(composite, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlGroup.setLayout((Layout)urlLayout);
        GridData data = new GridData(1808);
        urlGroup.setLayoutData((Object)data);
        Label urlLabel = new Label(urlGroup, 0);
        urlLabel.setText(Policy.bind("AnnotateDialog.url"));
        Text urlText = new Text(urlGroup, 2048);
        urlText.setEditable(false);
        data = new GridData();
        data.widthHint = 300;
        urlText.setLayoutData((Object)data);
        urlText.setText(this.remoteFile.getUrl().toString());
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("AnnotateDialog.from"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 3;
        fromGroup.setLayout((Layout)fromLayout);
        data = new GridData(1808);
        fromGroup.setLayoutData((Object)data);
        Label fromRevisionLabel = new Label((Composite)fromGroup, 0);
        fromRevisionLabel.setText(Policy.bind("AnnotateDialog.revision"));
        this.fromRevisionText = new Text((Composite)fromGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        this.fromRevisionText.setText("1");
        this.fromLogButton = new Button((Composite)fromGroup, 8);
        this.fromLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.fromLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotateDialog.this.showLog(e.getSource());
            }
        });
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("AnnotateDialog.to"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 3;
        toGroup.setLayout((Layout)toLayout);
        data = new GridData(1808);
        toGroup.setLayoutData((Object)data);
        this.headButton = new Button((Composite)toGroup, 16);
        this.headButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)toGroup, 16);
        this.revisionButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        this.headButton.setSelection(true);
        this.toRevisionText = new Text((Composite)toGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.toRevisionText.setEnabled(false);
        this.toLogButton = new Button((Composite)toGroup, 8);
        this.toLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.toLogButton.setEnabled(false);
        this.toLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotateDialog.this.showLog(e.getSource());
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AnnotateDialog.this.setOkButtonStatus();
            }
        };
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnnotateDialog.this.toRevisionText.setEnabled(AnnotateDialog.this.revisionButton.getSelection());
                AnnotateDialog.this.toLogButton.setEnabled(AnnotateDialog.this.revisionButton.getSelection());
                if (AnnotateDialog.this.revisionButton.getSelection()) {
                    AnnotateDialog.this.toRevisionText.selectAll();
                    AnnotateDialog.this.toRevisionText.setFocus();
                }
                AnnotateDialog.this.setOkButtonStatus();
            }
        };
        this.headButton.addSelectionListener((SelectionListener)selectionListener);
        this.revisionButton.addSelectionListener((SelectionListener)selectionListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.annotate_dialog_context");
        this.fromRevisionText.selectAll();
        this.fromRevisionText.setFocus();
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    protected void okPressed() {
        this.success = true;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    int fromRevisionInt = Integer.parseInt(AnnotateDialog.this.fromRevisionText.getText().trim());
                    long fromRevisionLong = fromRevisionInt;
                    SVNRevision.Number fromRevision = new SVNRevision.Number(fromRevisionLong);
                    SVNRevision toRevision = null;
                    if (AnnotateDialog.this.headButton.getSelection()) {
                        toRevision = SVNRevision.HEAD;
                    } else {
                        int toRevisionInt = Integer.parseInt(AnnotateDialog.this.toRevisionText.getText().trim());
                        long toRevisionLong = toRevisionInt;
                        toRevision = new SVNRevision.Number(toRevisionLong);
                    }
                    new ShowAnnotationOperation(AnnotateDialog.this.targetPart, AnnotateDialog.this.remoteFile, (SVNRevision)fromRevision, toRevision).run();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)AnnotateDialog.this.getShell(), (String)Policy.bind("AnnotateDialog.title"), (String)e.getMessage());
                    AnnotateDialog.this.success = false;
                }
            }
        });
        if (!this.success) {
            return;
        }
        super.okPressed();
    }

    private void setOkButtonStatus() {
        boolean canFinish = true;
        if (this.fromRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (this.revisionButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        this.okButton.setEnabled(canFinish);
    }

    private void showLog(Object sourceButton) {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteFile);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        if (sourceButton == this.fromLogButton) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        } else {
            this.toRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        }
        this.setOkButtonStatus();
    }
}

