/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.WorkingSetScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.internal.ContainerCheckedTreeViewer;

public class GlobalRefreshResourceSelectionPage
extends WizardPage {
    private boolean scopeCheckingElement = false;
    private Button participantScope;
    private Button selectedResourcesScope;
    private Button workingSetScope;
    private ContainerCheckedTreeViewer fViewer;
    private Text workingSetLabel;
    private IWorkingSet[] workingSets;
    private List resources;
    private IDialogSettings settings;
    private static final String STORE_SECTION = "SynchronizeResourceSelectionDialog";
    private static final String STORE_WORKING_SETS = "SynchronizeResourceSelectionDialog.STORE_WORKING_SETS";

    public GlobalRefreshResourceSelectionPage(IResource[] resources) {
        super(Policy.bind("GlobalRefreshResourceSelectionPage.1"));
        this.resources = Arrays.asList(resources);
        this.setDescription(Policy.bind("GlobalRefreshResourceSelectionPage.2"));
        this.setTitle(Policy.bind("GlobalRefreshResourceSelectionPage.3"));
        IDialogSettings s = SVNUIPlugin.getPlugin().getDialogSettings();
        this.settings = s.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = s.addNewSection(STORE_SECTION);
        }
    }

    public void createControl(Composite parent2) {
        Composite top = new Composite(parent2, 0);
        top.setLayout((Layout)new GridLayout());
        this.initializeDialogUnits((Control)top);
        GridData data = new GridData(1808);
        data.widthHint = 50;
        top.setLayoutData((Object)data);
        this.setControl((Control)top);
        Label l = new Label(top, 0);
        l.setText(Policy.bind("GlobalRefreshResourceSelectionPage.5"));
        this.fViewer = new ContainerCheckedTreeViewer(top, 2048);
        data = new GridData(1808);
        data.heightHint = 100;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new MyLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GlobalRefreshResourceSelectionPage.this.updateOKStatus();
            }
        });
        this.fViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        this.fViewer.setInput(this.resources);
        Composite selectGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectGroup.setLayout((Layout)layout);
        data = new GridData(768);
        selectGroup.setLayoutData((Object)data);
        Button selectAll = new Button(selectGroup, 0);
        selectAll.setText(Policy.bind("GlobalRefreshResourceSelectionPage.12"));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshResourceSelectionPage.this.participantScope.setSelection(true);
                GlobalRefreshResourceSelectionPage.this.selectedResourcesScope.setSelection(false);
                GlobalRefreshResourceSelectionPage.this.workingSetScope.setSelection(false);
                GlobalRefreshResourceSelectionPage.this.updateParticipantScope();
                GlobalRefreshResourceSelectionPage.this.scopeCheckingElement = true;
                GlobalRefreshResourceSelectionPage.this.updateOKStatus();
                GlobalRefreshResourceSelectionPage.this.scopeCheckingElement = false;
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deSelectAll = new Button(selectGroup, 0);
        deSelectAll.setText(Policy.bind("GlobalRefreshResourceSelectionPage.13"));
        deSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshResourceSelectionPage.this.fViewer.setCheckedElements(new Object[0]);
                GlobalRefreshResourceSelectionPage.this.updateOKStatus();
            }
        });
        this.setButtonLayoutData(deSelectAll);
        Group scopeGroup = new Group(top, 0);
        scopeGroup.setText(Policy.bind("GlobalRefreshResourceSelectionPage.6"));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        scopeGroup.setLayout((Layout)layout);
        data = new GridData(768);
        data.widthHint = 50;
        scopeGroup.setLayoutData((Object)data);
        this.participantScope = new Button((Composite)scopeGroup, 16);
        this.participantScope.setText(Policy.bind("GlobalRefreshResourceSelectionPage.7"));
        this.participantScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshResourceSelectionPage.this.updateParticipantScope();
            }
        });
        this.selectedResourcesScope = new Button((Composite)scopeGroup, 16);
        this.selectedResourcesScope.setText(Policy.bind("GlobalRefreshResourceSelectionPage.8"));
        this.selectedResourcesScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshResourceSelectionPage.this.updateSelectedResourcesScope();
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        this.selectedResourcesScope.setLayoutData((Object)data);
        this.workingSetScope = new Button((Composite)scopeGroup, 16);
        this.workingSetScope.setText(Policy.bind("GlobalRefreshResourceSelectionPage.10"));
        this.workingSetScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GlobalRefreshResourceSelectionPage.this.workingSetScope.getSelection()) {
                    GlobalRefreshResourceSelectionPage.this.updateWorkingSetScope();
                }
            }
        });
        this.workingSetLabel = new Text((Composite)scopeGroup, 2048);
        this.workingSetLabel.setEditable(false);
        data = new GridData(768);
        this.workingSetLabel.setLayoutData((Object)data);
        Button selectWorkingSetButton = new Button((Composite)scopeGroup, 0);
        selectWorkingSetButton.setText(Policy.bind("GlobalRefreshResourceSelectionPage.11"));
        selectWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalRefreshResourceSelectionPage.this.selectWorkingSetAction();
            }
        });
        data = new GridData(128);
        selectWorkingSetButton.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)selectWorkingSetButton);
        this.initializeScopingHint();
        Dialog.applyDialogFont((Control)top);
    }

    protected void updateOKStatus() {
        if (this.fViewer != null) {
            if (!this.scopeCheckingElement && !this.selectedResourcesScope.getSelection()) {
                this.selectedResourcesScope.setSelection(true);
                this.participantScope.setSelection(false);
                this.workingSetScope.setSelection(false);
                this.updateSelectedResourcesScope();
            }
            this.setPageComplete(this.areAnyElementsChecked() != null);
        } else {
            this.setPageComplete(false);
        }
    }

    private IResource areAnyElementsChecked() {
        TreeItem[] item = this.fViewer.getTree().getItems();
        int i = 0;
        while (i < item.length) {
            TreeItem child = item[i];
            if (child.getChecked() || child.getGrayed()) {
                return (IResource)child.getData();
            }
            ++i;
        }
        return null;
    }

    public IResource[] getRootResources() {
        TreeItem[] item = this.fViewer.getTree().getItems();
        ArrayList checked = new ArrayList();
        int i = 0;
        while (i < item.length) {
            TreeItem child = item[i];
            this.collectCheckedItems(child, checked);
            ++i;
        }
        return checked.toArray(new IResource[checked.size()]);
    }

    public ISynchronizeScope getSynchronizeScope() {
        if (this.workingSetScope.getSelection()) {
            return new WorkingSetScope(this.workingSets);
        }
        if (this.participantScope.getSelection()) {
            return new WorkspaceScope();
        }
        return new ResourceScope(this.getRootResources());
    }

    private void initializeScopingHint() {
        String working_sets = this.settings.get(STORE_WORKING_SETS);
        if (working_sets == null) {
            this.participantScope.setSelection(true);
            this.updateParticipantScope();
        } else {
            StringTokenizer st = new StringTokenizer(working_sets, " ,");
            ArrayList<IWorkingSet> ws = new ArrayList<IWorkingSet>();
            while (st.hasMoreTokens()) {
                IWorkingSetManager workingSetManager;
                IWorkingSet workingSet;
                String workingSetName = st.nextToken();
                if (workingSetName == null || workingSetName.equals("") || (workingSet = (workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) == null) continue;
                ws.add(workingSet);
            }
            if (!ws.isEmpty()) {
                this.workingSets = ws.toArray(new IWorkingSet[ws.size()]);
                this.updateWorkingSetScope();
                this.updateWorkingSetLabel();
                this.participantScope.setSelection(false);
                this.selectedResourcesScope.setSelection(false);
                this.workingSetScope.setSelection(true);
            }
        }
    }

    public void dispose() {
        if (this.workingSets != null && this.workingSetScope.getSelection()) {
            String concatsWorkingSets = this.makeWorkingSetLabel();
            this.settings.put(STORE_WORKING_SETS, concatsWorkingSets);
        } else {
            this.settings.put(STORE_WORKING_SETS, null);
        }
    }

    private void updateParticipantScope() {
        if (this.participantScope.getSelection()) {
            this.scopeCheckingElement = true;
            this.fViewer.setCheckedElements(this.resources.toArray());
            this.setPageComplete(this.getRootResources().length > 0);
            this.scopeCheckingElement = false;
        }
    }

    private void updateSelectedResourcesScope() {
        this.setPageComplete(this.getRootResources().length > 0);
    }

    private void selectWorkingSetAction() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        dialog.open();
        IWorkingSet[] sets = dialog.getSelection();
        if (sets == null) {
            return;
        }
        this.workingSets = sets;
        this.updateWorkingSetScope();
        this.updateWorkingSetLabel();
        this.participantScope.setSelection(false);
        this.selectedResourcesScope.setSelection(false);
        this.workingSetScope.setSelection(true);
    }

    private void updateWorkingSetScope() {
        if (this.workingSets != null) {
            ArrayList allWorkingSetResources = new ArrayList();
            int i = 0;
            while (i < this.workingSets.length) {
                IWorkingSet set = this.workingSets[i];
                allWorkingSetResources.addAll(IDE.computeSelectedResources((IStructuredSelection)new StructuredSelection((Object[])set.getElements())));
                ++i;
            }
            this.scopeCheckingElement = true;
            this.fViewer.setCheckedElements(allWorkingSetResources.toArray(new IResource[allWorkingSetResources.size()]));
            this.scopeCheckingElement = false;
            this.setPageComplete(true);
        } else {
            this.scopeCheckingElement = true;
            this.fViewer.setCheckedElements(new Object[0]);
            this.scopeCheckingElement = false;
            this.setPageComplete(false);
        }
    }

    private void collectCheckedItems(TreeItem item, List checked) {
        if (item.getChecked() && !item.getGrayed()) {
            checked.add(item.getData());
        } else if (item.getGrayed()) {
            TreeItem[] children = item.getItems();
            int i = 0;
            while (i < children.length) {
                TreeItem child = children[i];
                this.collectCheckedItems(child, checked);
                ++i;
            }
        }
    }

    private void updateWorkingSetLabel() {
        if (this.workingSets == null) {
            this.workingSetLabel.setText(Policy.bind("StatisticsPanel.noWorkingSet"));
        } else {
            this.workingSetLabel.setText(this.makeWorkingSetLabel());
        }
    }

    private String makeWorkingSetLabel() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.workingSets.length) {
            IWorkingSet set = this.workingSets[i];
            if (i != 0) {
                buffer.append(" ,");
            }
            buffer.append(set.getName());
            ++i;
        }
        return buffer.toString();
    }

    class MyContentProvider
    extends BaseWorkbenchContentProvider {
        MyContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray(new IResource[((List)element).size()]);
            }
            return super.getChildren(element);
        }
    }

    class MyLabelProvider
    extends LabelProvider {
        private LabelProvider workbenchProvider = new WorkbenchLabelProvider();

        MyLabelProvider() {
        }

        public String getText(Object element) {
            IContainer c;
            if (element instanceof IContainer && (c = (IContainer)element).getType() != 4 && GlobalRefreshResourceSelectionPage.this.resources.contains(c)) {
                return c.getFullPath().toString();
            }
            return this.workbenchProvider.getText(element);
        }

        public Image getImage(Object element) {
            return this.workbenchProvider.getImage(element);
        }
    }
}

