/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;

public abstract class RepositoryProviderOperation
extends SVNOperation {
    private IResource[] resources;

    public RepositoryProviderOperation(IWorkbenchPart part, IResource[] resources) {
        super(part);
        this.resources = resources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        Map table = this.getProviderMapping(this.getResources());
        Set keySet = table.keySet();
        monitor.beginTask(null, keySet.size() * 1000);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            Object var10_10;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
            List list = (List)table.get(provider);
            IResource[] providerResources = list.toArray(new IResource[list.size()]);
            ISchedulingRule rule = this.getSchedulingRule(provider);
            try {
                Job.getJobManager().beginRule(rule, monitor);
                monitor.setTaskName(this.getTaskName(provider));
                this.execute(provider, providerResources, (IProgressMonitor)subMonitor);
            }
            catch (Throwable throwable) {
                var10_10 = null;
                Job.getJobManager().endRule(rule);
                throw throwable;
            }
            {
                var10_10 = null;
            }
            Job.getJobManager().endRule(rule);
        }
        return;
    }

    protected abstract String getTaskName(SVNTeamProvider var1);

    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        return provider.getProject();
    }

    private Map getProviderMapping(IResource[] resources) {
        HashMap<RepositoryProvider, ArrayList<IResource>> result = new HashMap<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject(), (String)SVNProviderPlugin.getTypeId());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected IResource[] getResources() {
        return this.resources;
    }

    protected void setResources(IResource[] resources) {
        this.resources = resources;
    }

    protected abstract void execute(SVNTeamProvider var1, IResource[] var2, IProgressMonitor var3) throws SVNException, InterruptedException;

    protected ISVNResource[] getSVNArguments(IResource[] resources) {
        ISVNResource[] SVNResources = new ISVNResource[resources.length];
        int i = 0;
        while (i < SVNResources.length) {
            SVNResources[i] = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
            ++i;
        }
        return SVNResources;
    }

    protected String[] getStringArguments(IResource[] resources) throws SVNException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IPath svnPath = resources[i].getFullPath().removeFirstSegments(1);
            if (svnPath.segmentCount() == 0) {
                arguments.add(".");
            } else {
                arguments.add(svnPath.toString());
            }
            ++i;
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public ISVNResource[] getSVNResources() {
        ISVNResource[] svnResources = new ISVNResource[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            svnResources[i] = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
            ++i;
        }
        return svnResources;
    }

    protected ISVNRepositoryLocation getRemoteLocation(SVNTeamProvider provider) throws SVNException {
        SVNWorkspaceRoot workspaceRoot = provider.getSVNWorkspaceRoot();
        return workspaceRoot.getRepository();
    }

    protected ISVNFolder getLocalRoot(SVNTeamProvider provider) throws SVNException {
        SVNWorkspaceRoot workspaceRoot = provider.getSVNWorkspaceRoot();
        return workspaceRoot.getLocalRoot();
    }
}

