/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class CommentProperties {
    private int minimumLogMessageSize;
    private int logWidthMarker;
    private String logTemplate;
    private int minimumLockMessageSize;

    public String getLogTemplate() {
        return this.logTemplate;
    }

    public void setLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
    }

    public int getLogWidthMarker() {
        return this.logWidthMarker;
    }

    public void setLogWidthMarker(int logWidthMarker) {
        this.logWidthMarker = logWidthMarker;
    }

    public int getMinimumLogMessageSize() {
        return this.minimumLogMessageSize;
    }

    public void setMinimumLogMessageSize(int minimumLogMessageSize) {
        this.minimumLogMessageSize = minimumLogMessageSize;
    }

    public int getMinimumLockMessageSize() {
        return this.minimumLockMessageSize;
    }

    public void setMinimumLockMessageSize(int minimumLockMessageSize) {
        this.minimumLockMessageSize = minimumLockMessageSize;
    }

    public static CommentProperties getCommentProperties(IResource resource) throws SVNException {
        ISVNLocalResource svnResource;
        IProject project = null;
        project = resource instanceof IProject ? (IProject)resource : resource.getProject();
        if (project != null && (svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)project)).isManaged()) {
            ISVNProperty templateProperty;
            ISVNProperty widthProperty;
            ISVNProperty lockSizeProperty;
            CommentProperties properties = new CommentProperties();
            ISVNProperty sizeProperty = svnResource.getSvnProperty("tsvn:logminsize");
            if (sizeProperty != null) {
                int minSize = 0;
                try {
                    minSize = Integer.parseInt(sizeProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLogMessageSize(minSize);
            }
            if ((lockSizeProperty = svnResource.getSvnProperty("tsvn:lockmsgminsize")) != null) {
                int minSize = 0;
                try {
                    minSize = Integer.parseInt(lockSizeProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setMinimumLockMessageSize(minSize);
            }
            if ((widthProperty = svnResource.getSvnProperty("tsvn:logwidthmarker")) != null) {
                int width = 0;
                try {
                    width = Integer.parseInt(widthProperty.getValue());
                }
                catch (Exception exception) {}
                properties.setLogWidthMarker(width);
            }
            if ((templateProperty = svnResource.getSvnProperty("tsvn:logtemplate")) != null) {
                properties.setLogTemplate(templateProperty.getValue());
            }
            return properties;
        }
        return null;
    }
}

