/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SVNClientManager {
    private String svnClientInterface;
    private File configDir = null;
    private boolean fetchChangePathOnDemand = true;
    private boolean javahl = false;
    private boolean svnkit = false;

    public void startup(IProgressMonitor monitor) throws CoreException {
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
    }

    public void setSvnClientInterface(String svnClientInterface) {
        if (svnClientInterface == null) {
            this.loadJavaHLAdapter();
            try {
                this.svnClientInterface = SVNClientAdapterFactory.getPreferredSVNClientType();
            }
            catch (SVNClientException e) {
                SVNProviderPlugin.log(new TeamException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", 0, e.getMessage(), (Throwable)e)));
                return;
            }
        } else {
            if ("commandline".equals(svnClientInterface)) {
                svnClientInterface = "svnkit";
            }
            if ("javahl".equals(svnClientInterface)) {
                this.loadJavaHLAdapter();
            }
            if ("svnkit".equals(svnClientInterface)) {
                this.loadSVNKitAdapter();
            }
            if ("javasvn".equals(svnClientInterface)) {
                this.loadSVNKitAdapter();
            }
            if (SVNClientAdapterFactory.isSVNClientAvailable((String)svnClientInterface)) {
                this.svnClientInterface = svnClientInterface;
            } else if (this.svnClientInterface == null && SVNClientAdapterFactory.isSVNClientAvailable((String)"svnkit")) {
                this.svnClientInterface = "svnkit";
            }
        }
        SVNProviderPlugin.getPlugin().getAdminDirectoryName();
    }

    public String getSvnClientInterface() {
        if (this.svnClientInterface == null) {
            this.setSvnClientInterface(null);
        }
        return this.svnClientInterface;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public ISVNClientAdapter createSVNClient() throws SVNException {
        try {
            ISVNClientAdapter svnClient = SVNClientAdapterFactory.createSVNClient((String)this.getSvnClientInterface());
            if (this.configDir != null) {
                svnClient.setConfigDirectory(this.configDir);
            }
            if (SVNProviderPlugin.getPlugin().getSvnPromptUserPassword() != null) {
                svnClient.addPasswordCallback(SVNProviderPlugin.getPlugin().getSvnPromptUserPassword());
            }
            return svnClient;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
    }

    public boolean isFetchChangePathOnDemand() {
        return this.fetchChangePathOnDemand;
    }

    public void setFetchChangePathOnDemand(boolean fetchChangePathOnDemand) {
        this.fetchChangePathOnDemand = fetchChangePathOnDemand;
    }

    public void loadAdapters() {
        this.loadJavaHLAdapter();
        this.loadSVNKitAdapter();
    }

    private void loadJavaHLAdapter() {
        if (!this.javahl) {
            this.javahl = true;
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                this.loadSVNKitAdapter();
            }
        }
    }

    private void loadSVNKitAdapter() {
        if (!this.svnkit) {
            this.svnkit = true;
            try {
                SvnKitClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {}
        }
    }
}

