/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.ModifyModulesWizard;

public class ModifyModulesAction
extends Action {
    protected IWorkbenchPart part;
    protected IServer server;

    public ModifyModulesAction(IServer server) {
        super(Messages.actionModifyModules);
        this.server = server;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object obj;
        this.server = null;
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IServer) {
            this.server = (IServer)obj;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        if (this.server == null) {
            return;
        }
        Shell shell = this.part.getSite().getShell();
        ArrayList<IModule> deployed = new ArrayList<IModule>();
        ArrayList<IModule> modules = new ArrayList<IModule>();
        IModule[] currentModules = this.server.getModules();
        if (currentModules != null) {
            int size = currentModules.length;
            int i = 0;
            while (i < size) {
                deployed.add(currentModules[i]);
                ++i;
            }
        }
        IModule[] modules2 = ServerUtil.getModules((IModuleType[])this.server.getServerType().getRuntimeType().getModuleTypes());
        if (modules != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IStatus status;
                IModule module = modules2[i];
                if (!deployed.contains(module) && (status = this.server.canModifyModules(new IModule[]{module}, null, null)) != null && status.getSeverity() != 4) {
                    modules.add(module);
                }
                ++i;
            }
        }
        if (deployed.isEmpty() && modules.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogAddRemoveModulesNone);
            return;
        }
        ModifyModulesWizard wizard = new ModifyModulesWizard(this.server);
        ClosableWizardDialog dialog = new ClosableWizardDialog(shell, wizard);
        dialog.open();
    }
}

