/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.providers;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public interface IServerConnectionUIProvider
{
	/**
	 * This method will be called so that the information to get the connection information
	 * can be provided by a Third-party
	 * @param parentComposite
	 */
	public Composite getServerConnectionUI (Composite parentComposite);
	
	/**
	 * Will get called back with the active connection information
	 * Will be used to set information entered by the user
	 * @param connectionInformation - The active connection information
	 */
	public void setServerConnectionInformation (IServerConnectionInformation connectionInformation);
	
	/**
	 * @param the Server type chosen by the user
	 * @param the Server version chosen by the user
	 */
	public void setDatabaseDefinition (DatabaseDefinition definition);
	
	/**
	 * Will provide the parent page of the wizard
	 */
	public void setWizardPage (WizardPage parentPage);
	
	/**
	 * @return true if the sub page is complete
	 */
	public boolean determinePageCompletion ();
	
	/**
	 * Will load property values from IServerConnectionInformation
	 */
	public void loadProperties();
}
