/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class Hyperlink
extends AbstractHyperlink {
    private String text;
    private boolean underlined;

    public Hyperlink(Composite parent, int style) {
        super(parent, style);
        this.initAccessible();
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Hyperlink.this.getText();
                if (e.result == null) {
                    this.getHelp(e);
                }
            }

            public void getHelp(AccessibleEvent e) {
                e.result = Hyperlink.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = Hyperlink.this.toControl(new Point(e.x, e.y));
                e.childID = Hyperlink.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = Hyperlink.this.getBounds();
                Point pt = Hyperlink.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                if (Hyperlink.this.getSelection()) {
                    state = 6;
                }
                e.detail = state;
            }
        });
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= this.marginWidth * 2;
        }
        Point textSize = this.computeTextSize(innerWidth, hHint);
        int textWidth = textSize.x + 2 * this.marginWidth;
        int textHeight = textSize.y + 2 * this.marginHeight;
        return new Point(textWidth, textHeight);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
        this.redraw();
    }

    protected void paintHyperlink(GC gc) {
        Rectangle carea = this.getClientArea();
        Rectangle bounds = new Rectangle(this.marginWidth, this.marginHeight, carea.width - this.marginWidth - this.marginWidth, carea.height - this.marginHeight - this.marginHeight);
        this.paintText(gc, bounds);
    }

    protected void paintText(GC gc, Rectangle bounds) {
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            FormUtil.paintWrapText(gc, this.text, bounds, this.underlined);
        } else {
            Point textSize = this.computeTextSize(bounds.width, -1);
            int textWidth = textSize.x;
            int textHeight = textSize.y;
            gc.drawText(this.getText(), bounds.x, bounds.y, true);
            if (this.underlined) {
                int descent = gc.getFontMetrics().getDescent();
                int lineY = bounds.y + textHeight - descent + 1;
                gc.drawLine(bounds.x, lineY, bounds.x + textWidth, lineY);
            }
        }
    }

    protected Point computeTextSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        Point extent = (this.getStyle() & 0x40) != 0 && wHint != -1 ? FormUtil.computeWrapSize(gc, this.getText(), wHint) : gc.textExtent(this.getText());
        gc.dispose();
        return extent;
    }
}

