/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;

public abstract class DebugEventHandler {
    private AbstractModelProxy fModelProxy;
    public static boolean DEBUG_DELTAS = false;

    static {
        DEBUG_DELTAS = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/deltas"));
    }

    public DebugEventHandler(AbstractModelProxy proxy) {
        this.fModelProxy = proxy;
    }

    public synchronized void dispose() {
        this.fModelProxy = null;
    }

    protected synchronized AbstractModelProxy getModelProxy() {
        return this.fModelProxy;
    }

    protected abstract boolean handlesEvent(DebugEvent var1);

    protected void handleCreate(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleTerminate(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleSuspend(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleResumeExpectingSuspend(DebugEvent event) {
    }

    protected void handleResume(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleChange(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleOther(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleSuspendTimeout(DebugEvent event) {
        this.refreshRoot(event);
    }

    protected void handleLateSuspend(DebugEvent suspend, DebugEvent resume) {
        this.refreshRoot(suspend);
    }

    protected void refreshRoot(DebugEvent event) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 1024);
        this.fireDelta(delta);
    }

    protected void fireDelta(IModelDelta delta) {
        AbstractModelProxy modelProxy = this.getModelProxy();
        if (modelProxy != null) {
            if (DEBUG_DELTAS) {
                DebugUIPlugin.debug("FIRE DELTA: " + delta.toString());
            }
            modelProxy.fireModelChanged(delta);
        }
    }

    protected synchronized boolean isDisposed() {
        return this.fModelProxy == null;
    }
}

