/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingDialog;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class FormatTableRenderingAction
extends Action {
    private AbstractBaseTableRendering fRendering;
    int fColumnSize = -1;
    int fRowSize = -1;

    public FormatTableRenderingAction(AbstractBaseTableRendering rendering) {
        this.fRendering = rendering;
        this.setText(DebugUIMessages.FormatTableRenderingAction_16);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".FormatTableRenderingAction_context");
    }

    public void run() {
        FormatTableRenderingDialog dialog = new FormatTableRenderingDialog(this.fRendering, DebugUIPlugin.getShell());
        dialog.open();
        this.fColumnSize = dialog.getColumnSize();
        this.fRowSize = dialog.getRowSize();
        if (this.fColumnSize > 0 && this.fRowSize > 0) {
            int addressableSize = this.fRendering.getAddressableSize();
            int columnSizeInBytes = addressableSize * this.fColumnSize;
            int rowSizeInBytes = addressableSize * this.fRowSize;
            this.fRendering.format(rowSizeInBytes, columnSizeInBytes);
        }
    }
}

