/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.JarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.core.JavaCore;

public class VarJarFactoryContainer
extends JarFactoryContainer {
    private final String _id;
    private final File _jarFile;

    public VarJarFactoryContainer(IPath jarPath) {
        this._id = jarPath.toString();
        IPath resolved = JavaCore.getResolvedVariablePath((IPath)jarPath);
        if (resolved != null) {
            this._jarFile = resolved.toFile();
        } else {
            this._jarFile = null;
            Status s = AptPlugin.createWarningStatus(null, "The factorypath entry " + this._id + " could not be resolved");
            AptPlugin.log((IStatus)s);
        }
    }

    public FactoryContainer.FactoryType getType() {
        return FactoryContainer.FactoryType.VARJAR;
    }

    public File getJarFile() {
        return this._jarFile;
    }

    public String getId() {
        return this._id;
    }
}

