/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class ShowActionGroup
extends ActionGroup {
    private boolean fIsPackageExplorer;
    private IWorkbenchSite fSite;
    private ShowInPackageViewAction fShowInPackagesViewAction;

    public ShowActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public ShowActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
        this.fIsPackageExplorer = part instanceof PackageExplorerPart;
    }

    public ShowActionGroup(JavaEditor part) {
        this.fShowInPackagesViewAction = new ShowInPackageViewAction(part);
        this.fShowInPackagesViewAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.in.package.view");
        part.setAction("ShowInPackageView", (IAction)this.fShowInPackagesViewAction);
        this.initialize((IWorkbenchSite)part.getSite(), true);
    }

    private ShowActionGroup(IWorkbenchSite site) {
        this.fShowInPackagesViewAction = new ShowInPackageViewAction(site);
        this.fShowInPackagesViewAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.in.package.view");
        this.initialize(site, false);
    }

    private void initialize(IWorkbenchSite site, boolean isJavaEditor) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fShowInPackagesViewAction.update(selection);
        if (!isJavaEditor) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fShowInPackagesViewAction);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.fIsPackageExplorer) {
            this.appendToGroup(menu, (IAction)this.fShowInPackagesViewAction);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fShowInPackagesViewAction);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        if (!this.fIsPackageExplorer) {
            actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ShowInPackagesView", (IAction)this.fShowInPackagesViewAction);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.show", action);
        }
    }
}

