/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB1
extends BMPDecoder {
    public DecodeRGB1(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        Object object;
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        int n3 = n2 * n >> 3;
        int n4 = n2 >> 3;
        byte[] byArray = new byte[n3];
        for (int i = n - 1; i >= 0; --i) {
            int n5 = n4;
            if ((n5 & 3) != 0) {
                n5 += 4 - (n4 & 3);
            }
            if (imageInputStream.read((byte[])(object = new byte[n5])) != n5) {
                throw new IOException("Couldn't read image data.");
            }
            for (int j = 0; j < n4; ++j) {
                byArray[j + i * n4] = object[j];
            }
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n2, n, 1);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n3, 0);
        object = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBufferByte, null);
        return new BufferedImage(indexColorModel, (WritableRaster)object, false, null);
    }
}

