/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import java.io.IOException;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class HuffmanTable {
    public static final int HUFFMAN_MAX_TABLES = 4;
    private short[] huffcode;
    private short[] huffsize;
    private short[] EHUFCO;
    private short[] EHUFSI;
    private short[] valptr;
    private short[] mincode;
    private short[] maxcode;
    private short[] huffval;
    private short[] bits;
    static byte JPEG_DC_TABLE = 0;
    static byte JPEG_AC_TABLE = 1;
    private short lastk;

    private /* synthetic */ void finit$() {
        this.huffcode = new short[256];
        this.huffsize = new short[256];
        this.valptr = new short[16];
        this.mincode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.maxcode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.lastk = 0;
    }

    public HuffmanTable(JPEGHuffmanTable jPEGHuffmanTable) {
        this.finit$();
        this.huffcode = jPEGHuffmanTable.getValues();
        this.bits = jPEGHuffmanTable.getLengths();
    }

    private void generateSizeTable() {
        int n = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            for (int j = 0; j < this.bits[i]; ++j) {
                this.huffsize[n] = i + 1;
                ++n;
            }
        }
        this.lastk = n;
    }

    private void generateCodeTable() {
        int n = 0;
        int n2 = this.huffsize[0];
        int n3 = 0;
        for (int i = 0; i < this.huffsize.length; ++i) {
            while (this.huffsize[n] == n2) {
                this.huffcode[n] = n3++;
                ++n;
            }
            n3 = (short)(n3 << 1);
            ++n2;
        }
    }

    private void generateDecoderTables() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.bits[i] != 0) {
                this.valptr[i] = n;
            }
            for (int j = 0; j < this.bits[i]; ++j) {
                if (this.huffcode[j + n] < this.mincode[i] || this.mincode[i] == -1) {
                    this.mincode[i] = this.huffcode[j + n];
                }
                if (this.huffcode[j + n] <= this.maxcode[i]) continue;
                this.maxcode[i] = this.huffcode[j + n];
            }
            if (this.mincode[i] != -1) {
                this.valptr[i] = this.valptr[i] - this.mincode[i];
            }
            n = this.bits[i] + n;
        }
    }

    public void orderCodes(boolean bl) {
        this.EHUFCO = new short[bl ? 15 : 255];
        this.EHUFSI = new short[bl ? 15 : 255];
        for (int i = 0; i < this.lastk; ++i) {
            short s = this.huffval[i];
            if (s < 0 || s > this.EHUFCO.length || this.EHUFSI[s] != 0) {
                System.err.println("Error, bad huffman table.");
            }
            this.EHUFCO[s] = this.huffcode[i];
            this.EHUFSI[s] = this.huffsize[i];
        }
    }

    public static int extend(int n, int n2) {
        int n3 = (int)Math.pow(2.0, n2 - 1);
        if (n < n3) {
            n3 = (-1 << (n2 & 0x1F)) + 1;
            n += n3;
        }
        return n;
    }

    public int decode(JPEGImageInputStream jPEGImageInputStream) throws IOException, JPEGException {
        int n;
        int n2 = 0;
        for (n = (int)((int)jPEGImageInputStream.readBits(1)); n > this.maxcode[n2]; n |= (short)jPEGImageInputStream.readBits(1)) {
            ++n2;
            n = (short)(n << 1);
        }
        int n3 = this.huffval[n + this.valptr[n2]];
        if (n3 < 0) {
            n3 += 256;
        }
        return n3;
    }
}

