#!/bin/sh
echo 'name: convertible
version: 1.0.9.1
id: convertible-1.0.9.1-91e688d7a3ce8f6ea1cccb552db219b9

license: LGPL
copyright: Copyright (c) 2009-2010 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/ghc/convertible-1.0.9.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.9.1
hs-libraries: HSconvertible-1.0.9.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         containers-0.3.0.0-ee442470d8dcc9e45f31677c400c5379
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         old-locale-1.0.0.2-0c1a4b40f2d3b9f6b725f54c00fe0923
         old-time-1.0.0.5-99a656bc4f807d3640e245d60c3d290a
         time-1.1.4-d9f7b7932dc3a4863006ed6b1d525856
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.9.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.9.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
