#!/bin/sh
echo 'name: cryptohash
version: 0.6.1
id: cryptohash-0.6.1-3e359a01d476ce547f0d70fb653cc8f4

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger Data.CryptoHash.SHA1 Data.CryptoHash.SHA224
                 Data.CryptoHash.SHA256 Data.CryptoHash.SHA384
                 Data.CryptoHash.SHA512 Data.CryptoHash.MD2 Data.CryptoHash.MD4
                 Data.CryptoHash.MD5 Data.CryptoHash.RIPEMD160
                 Data.CryptoHash.Skein256 Data.CryptoHash.Skein512
                 Data.CryptoHash.Tiger
hidden-modules:
import-dirs: /usr/local/lib/ghc/cryptohash-0.6.1
library-dirs: /usr/local/lib/ghc/cryptohash-0.6.1
hs-libraries: HScryptohash-0.6.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         cereal-0.3.0.0-780d21095ae79ac3df7682af40a002c1
         crypto-api-0.2.1-39e481d004e818aa09631d0fc52d2bbe
         tagged-0.1.1-dc7f0ae3232e391c856024a6d3f33a4a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.6.1/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.6.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
