#!/bin/sh
echo 'name: hashed-storage
version: 0.5.2
id: hashed-storage-0.5.2-da0664781c8249d34d5fd96666d917e6

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.2
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.2
hs-libraries: HShashed-storage-0.5.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         binary-0.5.0.2-d8a2016532c382364dd8eb78608b883d
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         containers-0.3.0.0-ee442470d8dcc9e45f31677c400c5379
         dataenc-0.13.0.2-77e66d9d0bbcfc11bb0bc20e59edae9f
         directory-1.0.1.1-debc5b242c6cb9e9d9ae96c3aeec5419
         extensible-exceptions-0.1.1.1-28a83091e117b2e719d4a1c4a320a1c8
         filepath-1.1.0.4-c303c646a99c2a24d2402008d247eb5f
         mmap-0.5.6-fb88f48918ca5396c612a92d71799447
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         zlib-0.5.2.0-7acfb4dd7cb77e3a4b5beb3b9b160b08
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.2/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
