/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.embedder;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.idea.maven.embedder.MavenConsole;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenConsoleImpl
extends MavenConsole {
    private static final Key<MavenConsoleImpl> CONSOLE_KEY = Key.create((String)"MAVEN_CONSOLE_KEY");
    private static final String CONSOLE_FILTER_REGEXP = "$FILE_PATH$:\\[$LINE$,$COLUMN$]";
    private final String myTitle;
    private final Project myProject;
    private final ConsoleView myConsoleView;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final Pair<MavenRunnerParameters, MavenRunnerSettings> myParametersAndSettings;

    public MavenConsoleImpl(String title, Project project) {
        this(title, project, null);
    }

    public MavenConsoleImpl(String title, Project project, Pair<MavenRunnerParameters, MavenRunnerSettings> parametersAndSettings) {
        super(MavenConsoleImpl.getGeneralSettings(project).getLoggingLevel(), MavenConsoleImpl.getGeneralSettings(project).isPrintErrorStackTraces());
        this.myTitle = title;
        this.myProject = project;
        this.myConsoleView = this.createConsoleView();
        this.myParametersAndSettings = parametersAndSettings;
    }

    private static MavenGeneralSettings getGeneralSettings(Project project) {
        return MavenProjectsManager.getInstance(project).getGeneralSettings();
    }

    private ConsoleView createConsoleView() {
        return MavenConsoleImpl.createConsoleBuilder(this.myProject).getConsole();
    }

    public static TextConsoleBuilder createConsoleBuilder(Project project) {
        Filter[] filters;
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (Filter filter : filters = new Filter[]{new ExceptionFilter(project), new RegexpFilter(project, CONSOLE_FILTER_REGEXP)}) {
            builder.addFilter(filter);
        }
        return builder;
    }

    @Override
    public boolean canPause() {
        return this.myConsoleView.canPause();
    }

    @Override
    public boolean isOutputPaused() {
        return this.myConsoleView.isOutputPaused();
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
        this.myConsoleView.setOutputPaused(outputPaused);
    }

    public Pair<MavenRunnerParameters, MavenRunnerSettings> getParametersAndSettings() {
        return this.myParametersAndSettings;
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsoleView.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                MavenConsoleImpl.this.ensureAttachedToToolWindow();
            }
        });
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type) {
        ConsoleViewContentType contentType;
        this.ensureAttachedToToolWindow();
        switch (type) {
            case SYSTEM: {
                contentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case ERROR: {
                contentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        this.myConsoleView.print(text, contentType);
    }

    private void ensureAttachedToToolWindow() {
        if (!this.isOpen.compareAndSet(false, true)) {
            return;
        }
        MavenUtil.invokeLater(this.myProject, new Runnable(){

            @Override
            public void run() {
                MessageView messageView = MessageView.SERVICE.getInstance((Project)MavenConsoleImpl.this.myProject);
                Content content = ContentFactory.SERVICE.getInstance().createContent(MavenConsoleImpl.this.myConsoleView.getComponent(), MavenConsoleImpl.this.myTitle, true);
                content.putUserData(CONSOLE_KEY, (Object)MavenConsoleImpl.this);
                messageView.getContentManager().addContent(content);
                messageView.getContentManager().setSelectedContent(content);
                for (Content each : messageView.getContentManager().getContents()) {
                    MavenConsoleImpl console;
                    if (each.isPinned() || each == content || (console = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY)) == null || !MavenConsoleImpl.this.myTitle.equals(console.myTitle) || !console.isFinished()) continue;
                    messageView.getContentManager().removeContent(each, false);
                }
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)MavenConsoleImpl.this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (!toolWindow.isActive()) {
                    toolWindow.activate(null, false);
                }
            }
        });
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
        for (Content each : messageView.getContentManager().getContents()) {
            MavenConsoleImpl console = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY);
            if (console == null) continue;
            messageView.getContentManager().removeContent(each, true);
            return;
        }
    }
}

