/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleIgnoredProjectsAction
extends MavenAction {
    @Override
    public void update(AnActionEvent e) {
        List<MavenProject> projects;
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e);
        if (this.isIgnoredInSettings(projectsManager, projects = MavenActionUtil.getMavenProjects(e))) {
            e.getPresentation().setText(ProjectBundle.message("maven.ignore.edit", new Object[0]));
        } else if (this.isIgnored(projectsManager, projects)) {
            e.getPresentation().setText(ProjectBundle.message("maven.unignore", new Object[0]));
        } else {
            e.getPresentation().setText(ProjectBundle.message("maven.ignore", new Object[0]));
        }
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        if (!super.isAvailable(e)) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e);
        List<MavenProject> projects = MavenActionUtil.getMavenProjects(e);
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        int ignoredStatesCount = 0;
        int ignoredCount = 0;
        for (MavenProject each : projects) {
            if (projectsManager.getIgnoredState(each)) {
                ++ignoredStatesCount;
            }
            if (!projectsManager.isIgnored(each)) continue;
            ++ignoredCount;
        }
        return !(ignoredCount != 0 && ignoredCount != projects.size() || ignoredStatesCount != 0 && ignoredStatesCount != projects.size());
    }

    private boolean isIgnored(MavenProjectsManager projectsManager, List<MavenProject> projects) {
        return projectsManager.getIgnoredState(projects.get(0));
    }

    private boolean isIgnoredInSettings(MavenProjectsManager projectsManager, List<MavenProject> projects) {
        return projectsManager.isIgnored(projects.get(0)) && !this.isIgnored(projectsManager, projects);
    }

    public void actionPerformed(AnActionEvent e) {
        List<MavenProject> projects;
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e);
        if (this.isIgnoredInSettings(projectsManager, projects = MavenActionUtil.getMavenProjects(e))) {
            ShowSettingsUtil.getInstance().editConfigurable(MavenActionUtil.getProject(e), (Configurable)new MavenIgnoredFilesConfigurable(projectsManager));
        } else {
            projectsManager.setIgnoredState(projects, !this.isIgnored(projectsManager, projects));
        }
    }
}

