/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGotoSettingsFileContibutor
implements ChooseByNameContributor,
DumbAware {
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        if (!includeNonProjectItems) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        THashSet result = new THashSet();
        for (VirtualFile each : this.getSettingsFiles(project)) {
            result.add(each.getName());
        }
        return ArrayUtil.toStringArray((Collection)result);
    }

    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        if (!includeNonProjectItems) {
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (VirtualFile each : this.getSettingsFiles(project)) {
            PsiFile psiFile;
            if (!each.getName().equals(name) || (psiFile = PsiManager.getInstance((Project)project).findFile(each)) == null) continue;
            result.add(psiFile);
        }
        return result.toArray(new NavigationItem[result.size()]);
    }

    private List<VirtualFile> getSettingsFiles(Project project) {
        return MavenProjectsManager.getInstance(project).getGeneralSettings().getEffectiveSettingsFiles();
    }
}

