/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CollectionQuery<T>
implements Query<T> {
    private final Collection<T> myCollection;

    public CollectionQuery(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CollectionQuery.<init> must not be null");
        }
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<T> collection = this.myCollection;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/CollectionQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public T findFirst() {
        Iterator<T> i = this.iterator();
        return i.hasNext() ? (T)i.next() : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/CollectionQuery.forEach must not be null");
        }
        for (T t : this.myCollection) {
            if (consumer.process(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T[] toArray(T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myCollection.iterator();
    }
}

