/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;

    FileLoader(URL url) throws IOException {
        super(url);
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("url");
        }
        String s = FileUtil.unquote(url.getFile());
        this.myRootDir = new File(s);
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
    }

    private void buildPackageCache(File dir, ClasspathCache cache) {
        cache.addResourceEntry(this.getRelativeResourcePath(dir), this);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file : files) {
            boolean isClass = file.getPath().endsWith(".class");
            if (isClass) {
                if (containsClasses) continue;
                cache.addResourceEntry(this.getRelativeResourcePath(file), this);
                containsClasses = true;
                continue;
            }
            this.buildPackageCache(file, cache);
        }
    }

    private String getRelativeResourcePath(File file) {
        String relativePath = file.getAbsolutePath().substring(this.myRootDirAbsolutePath.length());
        if ((relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        try {
            URL url = new URL(this.getBaseURL(), name);
            if (!url.getFile().startsWith(this.getBaseURL().getFile())) {
                return null;
            }
            File file = new File(this.myRootDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                return new MyResource(name, url, file);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildCache(ClasspathCache cache) throws IOException {
        block6: {
            File index = new File(this.myRootDir, "classpath.index");
            if (index.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(index));
                try {
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block6;
                        }
                        cache.addResourceEntry(line, this);
                    }
                }
                finally {
                    reader.close();
                }
            }
            cache.addResourceEntry("foo.class", this);
            cache.addResourceEntry("bar.properties", this);
            this.buildPackageCache(this.myRootDir, cache);
        }
    }

    @NonNls
    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private class MyResource
    extends Resource {
        private final String myName;
        private final URL myUrl;
        private final File myFile;

        public MyResource(String name, URL url, File file) {
            this.myName = name;
            this.myUrl = url;
            this.myFile = file;
        }

        public String getName() {
            return this.myName;
        }

        public URL getURL() {
            return this.myUrl;
        }

        public URL getCodeSourceURL() {
            return FileLoader.this.getBaseURL();
        }

        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        public int getContentLength() throws IOException {
            return -1;
        }

        public String toString() {
            return this.myFile.getAbsolutePath();
        }
    }
}

