/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    private static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = new NotNullFunction<PsiElement, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PsiElement element) {
            List list = ContainerUtil.createMaybeSingletonList((Object)element);
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$1.fun must not return null");
            }
            return list;
        }
    };
    private final Icon myIcon;
    private final NotNullFunction<T, Collection<? extends PsiElement>> myConvertor;
    private NotNullLazyValue<Collection<? extends T>> myTargets;
    private boolean myLazy;
    private String myTooltipText;
    private String myPopupTitle;
    private String myEmptyText;
    private String myTooltipTitle;
    private GutterIconRenderer.Alignment myAlignment;
    private PsiElementListCellRenderer myCellRenderer;
    private NullableFunction<T, String> myNamer;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = new NotNullFunction<DomElement, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(DomElement o) {
            List list = ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$2.fun must not return null");
            }
            return list;
        }
    };

    protected NavigationGutterIconBuilder(@NotNull Icon icon, NotNullFunction<T, Collection<? extends PsiElement>> convertor) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.<init> must not be null");
        }
        this.myAlignment = GutterIconRenderer.Alignment.CENTER;
        this.myNamer = ElementPresentationManager.NAMER;
        this.myIcon = icon;
        this.myConvertor = convertor;
    }

    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.create must not be null");
        }
        return NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR);
    }

    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, NotNullFunction<T, Collection<? extends PsiElement>> convertor) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.create must not be null");
        }
        return new NavigationGutterIconBuilder<T>(icon, convertor);
    }

    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target) {
        return this.setTargets(ContainerUtil.createMaybeSingletonList(target));
    }

    public NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setTargets must not be null");
        }
        return this.setTargets((Collection<? extends T>)Arrays.asList(targets));
    }

    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setTargets must not be null");
        }
        this.myTargets = targets;
        this.myLazy = true;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTargets(final @NotNull Collection<? extends T> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setTargets must not be null");
        }
        this.myTargets = new NotNullLazyValue<Collection<? extends T>>(){

            @NotNull
            public Collection<? extends T> compute() {
                Collection collection = targets;
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$3.compute must not return null");
                }
                return collection;
            }
        };
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull String tooltipText) {
        if (tooltipText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setTooltipText must not be null");
        }
        this.myTooltipText = tooltipText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setAlignment must not be null");
        }
        this.myAlignment = alignment;
        return this;
    }

    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull String popupTitle) {
        if (popupTitle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setPopupTitle must not be null");
        }
        this.myPopupTitle = popupTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setEmptyPopupText must not be null");
        }
        this.myEmptyText = emptyText;
        return this;
    }

    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull String tooltipTitle) {
        if (tooltipTitle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setTooltipTitle must not be null");
        }
        this.myTooltipTitle = tooltipTitle;
        return this;
    }

    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<T, String> namer) {
        if (namer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setNamer must not be null");
        }
        this.myNamer = namer;
        return this;
    }

    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.setCellRenderer must not be null");
        }
        this.myCellRenderer = cellRenderer;
        return this;
    }

    @Nullable
    public Annotation install(@NotNull DomElementAnnotationHolder holder, @Nullable DomElement element) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.install must not be null");
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createAnnotation(element, HighlightSeverity.INFORMATION, null), element.getManager().getProject());
    }

    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/NavigationGutterIconBuilder.install must not be null");
        }
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createInfoAnnotation(element, null), element.getProject());
    }

    private Annotation doInstall(Annotation annotation, Project project) {
        MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(project);
        annotation.setGutterIconRenderer(renderer);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    public LineMarkerInfo createLineMarkerInfo(PsiElement element) {
        final MyNavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject());
        return new LineMarkerInfo<PsiElement>(element, element.getTextRange(), renderer.getIcon(), 6, (Function<PsiElement, String>)new NullableFunction<PsiElement, String>(){

            public String fun(PsiElement element) {
                return renderer.getTooltipText();
            }
        }, (GutterIconNavigationHandler<PsiElement>)renderer, renderer.getAlignment());
    }

    private MyNavigationGutterIconRenderer createGutterIconRenderer(Project project) {
        final SmartPointerManager manager = SmartPointerManager.getInstance(project);
        NotNullLazyValue<List<SmartPsiElementPointer>> pointers = new NotNullLazyValue<List<SmartPsiElementPointer>>(){

            @NotNull
            public List<SmartPsiElementPointer> compute() {
                THashSet elements = new THashSet();
                ArrayList<SmartPsiElementPointer> list = new ArrayList<SmartPsiElementPointer>();
                for (Object target : (Collection)NavigationGutterIconBuilder.this.myTargets.getValue()) {
                    for (PsiElement psiElement : (Collection)NavigationGutterIconBuilder.this.myConvertor.fun(target)) {
                        if (!elements.add(psiElement)) continue;
                        list.add(manager.createSmartPsiElementPointer(psiElement));
                    }
                }
                ArrayList<SmartPsiElementPointer> arrayList = list;
                if (arrayList == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$5.compute must not return null");
                }
                return arrayList;
            }
        };
        if (!this.myLazy) {
            pointers.getValue();
        }
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text = (String)this.myNamer.fun(t);
                if (text == null) continue;
                names.add(MessageFormat.format(PATTERN, text));
            }
            StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name : names) {
                sb.append(name).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        if (this.myCellRenderer == null) {
            this.myCellRenderer = new DefaultPsiElementCellRenderer();
        }
        MyNavigationGutterIconRenderer renderer = new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers);
        return renderer;
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final String myTooltipText;

        public MyNavigationGutterIconRenderer(NavigationGutterIconBuilder builder, GutterIconRenderer.Alignment alignment, Icon icon, String tooltipText, NotNullLazyValue<List<SmartPsiElementPointer>> pointers) {
            super(builder.myPopupTitle, builder.myEmptyText, builder.myCellRenderer, pointers);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/NavigationGutterIconBuilder$MyNavigationGutterIconRenderer.getIcon must not return null");
            }
            return icon;
        }

        @Override
        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        @Override
        public GutterIconRenderer.Alignment getAlignment() {
            return this.myAlignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)o;
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null) {
                return false;
            }
            return !(this.myTooltipText != null ? !this.myTooltipText.equals(that.myTooltipText) : that.myTooltipText != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result = 31 * result + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result;
        }
    }
}

