/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessHandler
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.ProcessHandler");
    public static final Key<Boolean> SILENTLY_DESTROY_ON_CLOSE = Key.create((String)"SILENTLY_DESTROY_ON_CLOSE");
    private final List<ProcessListener> myListeners = ContainerUtil.createEmptyCOWList();
    private static final int STATE_INITIAL = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_TERMINATING = 2;
    private static final int STATE_TERMINATED = 3;
    private final AtomicInteger myState = new AtomicInteger(0);
    private final Semaphore myWaitSemaphore;
    private final ProcessListener myEventMulticaster = this.createEventMulticaster();

    protected ProcessHandler() {
        this.myWaitSemaphore = new Semaphore();
        this.myWaitSemaphore.down();
    }

    public void startNotify() {
        if (this.myState.compareAndSet(0, 1)) {
            this.myEventMulticaster.startNotified(new ProcessEvent(this));
        } else {
            LOG.error("startNotify called already");
        }
    }

    protected abstract void destroyProcessImpl();

    protected abstract void detachProcessImpl();

    public abstract boolean detachIsDefault();

    public void waitFor() {
        try {
            this.myWaitSemaphore.waitFor();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        try {
            return this.myWaitSemaphore.waitFor(timeoutInMilliseconds);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public void destroyProcess() {
        this.afterStartNotified(new Runnable(){

            @Override
            public void run() {
                if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                    ProcessHandler.this.fireProcessWillTerminate(true);
                    ProcessHandler.this.destroyProcessImpl();
                }
            }
        });
    }

    public void detachProcess() {
        this.afterStartNotified(new Runnable(){

            @Override
            public void run() {
                if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                    ProcessHandler.this.fireProcessWillTerminate(false);
                    ProcessHandler.this.detachProcessImpl();
                }
            }
        });
    }

    public boolean isProcessTerminated() {
        return this.myState.get() == 3;
    }

    public boolean isProcessTerminating() {
        return this.myState.get() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener listener) {
        List<ProcessListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener listener) {
        List<ProcessListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    protected void notifyProcessDetached() {
        this.notifyTerminated(0, false);
    }

    protected void notifyProcessTerminated(int exitCode) {
        this.notifyTerminated(exitCode, true);
    }

    private void notifyTerminated(final int exitCode, final boolean willBeDestroyed) {
        this.afterStartNotified(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.assertTrue(ProcessHandler.this.isStartNotified(), (Object)"Start notify is not called");
                if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                    try {
                        ProcessHandler.this.fireProcessWillTerminate(willBeDestroyed);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
                if (ProcessHandler.this.myState.compareAndSet(2, 3)) {
                    try {
                        ProcessHandler.this.myEventMulticaster.processTerminated(new ProcessEvent(ProcessHandler.this, exitCode));
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                    finally {
                        ProcessHandler.this.myWaitSemaphore.up();
                    }
                }
            }
        });
    }

    public void notifyTextAvailable(String text, Key outputType) {
        ProcessEvent event = new ProcessEvent(this, text);
        this.myEventMulticaster.onTextAvailable(event, outputType);
    }

    @Nullable
    public abstract OutputStream getProcessInput();

    private void fireProcessWillTerminate(boolean willBeDestroyed) {
        LOG.assertTrue(this.isStartNotified(), (Object)"All events should be fired after startNotify is called");
        this.myEventMulticaster.processWillTerminate(new ProcessEvent(this), willBeDestroyed);
    }

    private void afterStartNotified(final Runnable runnable) {
        if (this.isStartNotified()) {
            runnable.run();
        } else {
            this.addProcessListener(new ProcessAdapter(){

                @Override
                public void startNotified(ProcessEvent event) {
                    ProcessHandler.this.removeProcessListener(this);
                    runnable.run();
                }
            });
        }
    }

    public boolean isStartNotified() {
        return this.myState.get() > 0;
    }

    private ProcessListener createEventMulticaster() {
        Class<ProcessListener> listenerClass = ProcessListener.class;
        return (ProcessListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object object, Method method, Object[] params) throws Throwable {
                Iterator iterator;
                List list = ProcessHandler.this.myListeners;
                synchronized (list) {
                    iterator = ProcessHandler.this.myListeners.iterator();
                }
                while (iterator.hasNext()) {
                    ProcessListener processListener = (ProcessListener)iterator.next();
                    try {
                        method.invoke((Object)processListener, params);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
                return null;
            }
        });
    }
}

