/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelModuleExtension
extends ModuleExtension<LanguageLevelModuleExtension> {
    @NonNls
    private static final String LANGUAGE_LEVEL_ELEMENT_NAME = "LANGUAGE_LEVEL";
    private Module myModule;
    private final boolean myWritable;
    private static final Logger LOG = Logger.getInstance((String)("#" + LanguageLevelModuleExtension.class.getName()));
    private LanguageLevel myLanguageLevel;
    private final LanguageLevelModuleExtension mySource;

    public static LanguageLevelModuleExtension getInstance(Module module) {
        return ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtension.class);
    }

    public LanguageLevelModuleExtension(Module module) {
        this.myModule = module;
        this.mySource = null;
        this.myWritable = false;
    }

    public LanguageLevelModuleExtension(LanguageLevelModuleExtension source, boolean writable) {
        this.myWritable = writable;
        this.myModule = source.myModule;
        this.myLanguageLevel = source.myLanguageLevel;
        this.mySource = source;
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        LOG.assertTrue(this.myWritable, (Object)"Writable model can be retrieved from writable ModifiableRootModel");
        if (this.mySource == null && this.myModule.isLoaded() && this.myLanguageLevel != languageLevel) {
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance(this.myModule.getProject());
            LanguageLevel projectLanguageLevel = languageLevelProjectExtension.getLanguageLevel();
            if (!(languageLevel == null && this.myLanguageLevel == projectLanguageLevel || this.myLanguageLevel == null && languageLevel == projectLanguageLevel)) {
                languageLevelProjectExtension.reloadProjectOnLanguageLevelChange(languageLevel, true);
            }
        }
        this.myLanguageLevel = languageLevel;
    }

    @Nullable
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String languageLevel = element.getAttributeValue(LANGUAGE_LEVEL_ELEMENT_NAME);
        if (languageLevel != null) {
            try {
                this.myLanguageLevel = LanguageLevel.valueOf(languageLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myLanguageLevel != null) {
            element.setAttribute(LANGUAGE_LEVEL_ELEMENT_NAME, this.myLanguageLevel.toString());
        }
    }

    @Override
    public ModuleExtension getModifiableModel(boolean writable) {
        return new LanguageLevelModuleExtension(this, writable);
    }

    @Override
    public void commit() {
        if (this.mySource != null && this.mySource.myLanguageLevel != this.myLanguageLevel) {
            this.mySource.myLanguageLevel = this.myLanguageLevel;
        }
    }

    @Override
    public boolean isChanged() {
        return this.mySource != null && this.mySource.myLanguageLevel != this.myLanguageLevel;
    }

    public void dispose() {
        this.myModule = null;
        this.myLanguageLevel = null;
    }
}

