/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SmartList;
import java.util.List;

public class ProjectClasspathTraversing {
    public static final AddModuleOutput ALL_OUTPUTS = new AddModuleOutput(true);
    public static final AddModuleOutput GENERAL_OUTPUT = new AddModuleOutput(false);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH = new ProjectRootsTraversing.RootTraversePolicy(ALL_OUTPUTS, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES, null);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASS_RECURSIVE_WO_JDK = new ProjectRootsTraversing.RootTraversePolicy(ALL_OUTPUTS, null, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH_RECURSIVE = new ProjectRootsTraversing.RootTraversePolicy(ALL_OUTPUTS, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH_WITHOUT_JDK_AND_TESTS = new ProjectRootsTraversing.RootTraversePolicy(GENERAL_OUTPUT, null, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE_WITHOUT_TESTS);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH_WITHOUT_JDK_AND_TESTS_AND_PROVIDED = new ProjectRootsTraversing.RootTraversePolicy(GENERAL_OUTPUT, null, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS_AND_PROVIDED, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE_WITHOUT_TESTS_AND_PROVIDED);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH_WITHOUT_TESTS = new ProjectRootsTraversing.RootTraversePolicy(GENERAL_OUTPUT, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE_WITHOUT_TESTS);
    public static final ProjectRootsTraversing.RootTraversePolicy FULL_CLASSPATH_WITHOUT_TESTS_AND_PROVIDED = new ProjectRootsTraversing.RootTraversePolicy(GENERAL_OUTPUT, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS_AND_PROVIDED, ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES_WITHOUT_TESTS_AND_PROVIDED, ProjectRootsTraversing.RootTraversePolicy.RECURSIVE_WITHOUT_TESTS_AND_PROVIDED);

    private ProjectClasspathTraversing() {
    }

    public static class AddModuleOutput
    implements ProjectRootsTraversing.RootTraversePolicy.Visit<ModuleSourceOrderEntry> {
        private final boolean myIncludeTests;

        public AddModuleOutput(boolean includeTests) {
            this.myIncludeTests = includeTests;
        }

        @Override
        public void visit(ModuleSourceOrderEntry sourceEntry, ProjectRootsTraversing.TraverseState traverseState, RootPolicy<ProjectRootsTraversing.TraverseState> policy) {
            traverseState.addAllUrls(this.getOutputs(traverseState.getCurrentModuleManager().getModule()));
        }

        public List<String> getOutputs(Module module) {
            SmartList outputs = new SmartList();
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance(module);
            if (compilerModuleExtension != null) {
                String output;
                String testOutput = compilerModuleExtension.getCompilerOutputUrlForTests();
                if (this.myIncludeTests && testOutput != null) {
                    outputs.add(testOutput);
                }
                if (!(Comparing.equal((String)(output = compilerModuleExtension.getCompilerOutputUrl()), (String)testOutput) && this.myIncludeTests || output == null)) {
                    outputs.add(output);
                }
            }
            return outputs;
        }
    }
}

