/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(PsiFile file) {
        return DefaultStubBuilder.buildStubTreeFor(file, this.createStubForFile(file));
    }

    protected StubElement createStubForFile(PsiFile file) {
        return new PsiFileStubImpl<PsiFile>(file);
    }

    protected static StubElement buildStubTreeFor(PsiElement elt, StubElement parentStub) {
        StubElement<Object> stub = parentStub;
        if (elt instanceof StubBasedPsiElement) {
            IStubElementType type = ((StubBasedPsiElement)elt).getElementType();
            if (type.shouldCreateStub(elt.getNode())) {
                stub = type.createStub(elt, parentStub);
            }
        } else {
            IElementType type;
            ASTNode node = elt.getNode();
            IElementType iElementType = type = node == null ? null : node.getElementType();
            if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + elt);
            }
        }
        for (PsiElement child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            DefaultStubBuilder.buildStubTreeFor(child, stub);
        }
        return stub;
    }
}

