/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import junit.framework.Assert;

public class IdeaTestUtil
extends PlatformTestUtil {
    public static final Comparator<AbstractTreeNode> DEFAULT_COMPARATOR = new Comparator<AbstractTreeNode>(){

        @Override
        public int compare(AbstractTreeNode o1, AbstractTreeNode o2) {
            String displayText1 = o1.getTestPresentation();
            String displayText2 = o2.getTestPresentation();
            return displayText1.compareTo(displayText2);
        }
    };
    public static final CvsVirtualFileFilter CVS_FILE_FILTER = new CvsVirtualFileFilter();

    private static HashMap<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, VirtualFileFilter filter) {
        HashMap map = new HashMap();
        for (VirtualFile file : files) {
            if (filter != null && !filter.accept(file)) continue;
            map.put((Object)file.getName(), (Object)file);
        }
        return map;
    }

    public static void assertDirectoriesEqual(VirtualFile dirAfter, VirtualFile dirBefore, VirtualFileFilter fileFilter) throws IOException {
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirAfter.getChildren();
        File[] ioAfter = new File(dirAfter.getPath()).listFiles();
        IdeaTestUtil.shallowCompare(childrenAfter, ioAfter);
        VirtualFile[] childrenBefore = dirBefore.getChildren();
        File[] ioBefore = new File(dirBefore.getPath()).listFiles();
        IdeaTestUtil.shallowCompare(childrenBefore, ioBefore);
        HashMap<String, VirtualFile> mapAfter = IdeaTestUtil.buildNameToFileMap(childrenAfter, fileFilter);
        HashMap<String, VirtualFile> mapBefore = IdeaTestUtil.buildNameToFileMap(childrenBefore, fileFilter);
        Set keySetAfter = mapAfter.keySet();
        Set keySetBefore = mapBefore.keySet();
        Assert.assertEquals((Object)keySetAfter, (Object)keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = (VirtualFile)mapAfter.get((Object)name);
            VirtualFile fileBefore = (VirtualFile)mapBefore.get((Object)name);
            if (fileAfter.isDirectory()) {
                IdeaTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter);
                continue;
            }
            IdeaTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile[] vfs, File[] io) {
        ArrayList<String> vfsPaths = new ArrayList<String>();
        for (VirtualFile file : vfs) {
            vfsPaths.add(file.getPath());
        }
        ArrayList<String> ioPaths = new ArrayList<String>();
        for (File file : io) {
            ioPaths.add(file.getPath().replace(File.separatorChar, '/'));
        }
        Assert.assertEquals((String)IdeaTestUtil.sortAndJoin(vfsPaths), (String)IdeaTestUtil.sortAndJoin(ioPaths));
    }

    private static String sortAndJoin(List<String> strings) {
        Collections.sort(strings);
        StringBuilder buf = new StringBuilder();
        for (String string : strings) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static void assertFilesEqual(VirtualFile fileAfter, VirtualFile fileBefore) throws IOException {
        IdeaTestUtil.assertJarFilesEqual(VfsUtil.virtualToIoFile(fileAfter), VfsUtil.virtualToIoFile(fileBefore));
    }

    public static void assertJarFilesEqual(File file1, File file2) throws IOException {
        JarFile jarFile2;
        JarFile jarFile1;
        try {
            jarFile1 = new JarFile(file1);
            jarFile2 = new JarFile(file2);
        }
        catch (IOException e) {
            String textAfter = String.valueOf(FileUtil.loadFileText((File)file1));
            String textBefore = String.valueOf(FileUtil.loadFileText((File)file2));
            textAfter = StringUtil.convertLineSeparators((String)textAfter);
            textBefore = StringUtil.convertLineSeparators((String)textBefore);
            Assert.assertEquals((String)file1.getPath(), (String)textAfter, (String)textBefore);
            return;
        }
        File tempDirectory1 = IdeaTestCase.createTempDir((String)"tmp1");
        File tempDirectory2 = IdeaTestCase.createTempDir((String)"tmp2");
        ZipUtil.extract((ZipFile)jarFile1, (File)tempDirectory1, (FilenameFilter)CVS_FILE_FILTER);
        ZipUtil.extract((ZipFile)jarFile2, (File)tempDirectory2, (FilenameFilter)CVS_FILE_FILTER);
        jarFile1.close();
        jarFile2.close();
        final VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory1);
        final VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory2);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            }
        });
        IdeaTestUtil.assertDirectoriesEqual(dirAfter, dirBefore, CVS_FILE_FILTER);
    }

    public static void main(String[] args) {
        IdeaTestUtil.printDetectedPerformanceTimings();
    }

    public static void printDetectedPerformanceTimings() {
        System.out.println("Etalon timing: 438");
        System.out.println("This machine timing: " + Timings.MACHINE_TIMING);
    }

    public static class CvsVirtualFileFilter
    implements VirtualFileFilter,
    FilenameFilter {
        @Override
        public boolean accept(VirtualFile file) {
            return !file.isDirectory() || !"CVS".equals(file.getName());
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf("CVS") == -1;
        }
    }
}

