/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;

public final class TargetAction
extends AnAction {
    public static final String DEFAULT_TARGET_NAME = AntBundle.message("ant.target.name.default.target", new Object[0]);
    private final String myBuildName;
    private final String[] myTargets;
    private final String myDebugString;

    public TargetAction(AntBuildFile buildFile, String displayName, String[] targets, String description) {
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(displayName, false);
        templatePresentation.setDescription(description);
        this.myBuildName = buildFile.getPresentableName();
        this.myTargets = targets;
        this.myDebugString = "Target action: " + displayName + "; Build: " + buildFile.getPresentableName() + "; Project: " + buildFile.getProject().getLocation();
    }

    public String toString() {
        return this.myDebugString;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        for (AntBuildFile buildFile : AntConfiguration.getInstance(project).getBuildFiles()) {
            String name = buildFile.getPresentableName();
            if (name == null || !this.myBuildName.equals(name)) continue;
            String[] targets = this.myTargets.length == 1 && DEFAULT_TARGET_NAME.equals(this.myTargets[0]) ? ArrayUtil.EMPTY_STRING_ARRAY : this.myTargets;
            ExecutionHandler.runBuild((AntBuildFileBase)buildFile, targets, null, dataContext, AntBuildListener.NULL);
            return;
        }
    }
}

