/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.OptionsMessageDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsManagerImpl
extends ExternalAnnotationsManager {
    public static final Icon ICON = IconLoader.getIcon((String)"/modules/annotation.png");
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalAnnotationsManagerImpl.class.getName()));
    private final Map<VirtualFile, List<XmlFile>> myExternalAnotations = new ConcurrentWeakHashMap();
    private static final List<XmlFile> NULL = new ArrayList<XmlFile>();
    private final PsiManager myPsiManager;

    public ExternalAnnotationsManagerImpl(Project project, PsiManager psiManager) {
        this.myPsiManager = psiManager;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                ExternalAnnotationsManagerImpl.this.myExternalAnotations.clear();
            }
        });
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(PsiModifierListOwner listOwner, String annotationFQN) {
        return this.collectExternalAnnotations(listOwner).get(annotationFQN);
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(PsiModifierListOwner listOwner) {
        Map<String, PsiAnnotation> result = this.collectExternalAnnotations(listOwner);
        return result.isEmpty() ? null : result.values().toArray(new PsiAnnotation[result.size()]);
    }

    private Map<String, PsiAnnotation> collectExternalAnnotations(PsiModifierListOwner listOwner) {
        HashMap<String, PsiAnnotation> result = new HashMap<String, PsiAnnotation>();
        List<XmlFile> files = this.findExternalAnnotationsFile(listOwner);
        if (files != null) {
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false);
                String oldExternalName = ExternalAnnotationsManagerImpl.getNormalizedExternalName(listOwner);
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className = tag.getAttributeValue("name");
                    if (!Comparing.strEqual((String)className, (String)externalName) && !Comparing.strEqual((String)className, (String)oldExternalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        String annotationFQN = annotationTag.getAttributeValue("name");
                        StringBuilder buf = new StringBuilder();
                        for (XmlTag annotationaParameter : annotationTag.getSubTags()) {
                            buf.append(",").append(annotationaParameter.getAttributeValue("name")).append("=").append(annotationaParameter.getAttributeValue("value"));
                        }
                        String annotationText = "@" + annotationFQN + (buf.length() > 0 ? "(" + StringUtil.trimStart((String)buf.toString(), (String)",") + ")" : "");
                        try {
                            result.put(annotationFQN, JavaPsiFacade.getInstance((Project)listOwner.getProject()).getElementFactory().createAnnotationFromText(annotationText, null));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        }
        return result;
    }

    public void annotateExternally(final PsiModifierListOwner listOwner, final String annotationFQName, final PsiFile fromFile) {
        final Project project = listOwner.getProject();
        PsiFile containingFile = listOwner.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            final String packageName = ((PsiJavaFile)containingFile).getPackageName();
            final VirtualFile virtualFile = containingFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
            if (!entries.isEmpty()) {
                for (final OrderEntry entry : entries) {
                    if (entry instanceof ModuleOrderEntry) continue;
                    VirtualFile[] virtualFiles = AnnotationOrderRootType.getFiles((OrderEntry)entry);
                    if (virtualFiles.length > 0) {
                        this.chooseRootAndAnnotateExternally(listOwner, annotationFQName, fromFile, project, packageName, virtualFile, virtualFiles);
                        break;
                    }
                    if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExternalAnnotationsManagerImpl.this.setupRootAndAnnotateExternally(entry, project, listOwner, annotationFQName, fromFile, packageName, virtualFile);
                        }
                    });
                    break;
                }
            }
        }
    }

    private void setupRootAndAnnotateExternally(final OrderEntry entry, final Project project, final PsiModifierListOwner listOwner, final String annotationFQName, final PsiFile fromFile, final String packageName, final VirtualFile virtualFile) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(ProjectBundle.message((String)"external.annotations.root.chooser.title", (Object[])new Object[]{entry.getPresentableName()}));
        descriptor.setDescription(ProjectBundle.message((String)"external.annotations.root.chooser.description", (Object[])new Object[0]));
        final VirtualFile[] files = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)descriptor);
        if (files.length > 0) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    if (files[0] != null) {
                        ExternalAnnotationsManagerImpl.this.appendChosenAnnotationsRoot(entry, files[0]);
                        List xmlFiles = ExternalAnnotationsManagerImpl.this.findExternalAnnotationsFile(listOwner);
                        if (xmlFiles != null) {
                            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{((XmlFile)xmlFiles.get(0)).getVirtualFile()}).hasReadonlyFiles()) {
                                return;
                            }
                            ExternalAnnotationsManagerImpl.annotateExternally(listOwner, annotationFQName, (XmlFile)xmlFiles.get(0), fromFile);
                        } else {
                            XmlFile annotationsXml = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(files[0], packageName);
                            if (annotationsXml != null) {
                                ArrayList<XmlFile> createdFiles = new ArrayList<XmlFile>();
                                createdFiles.add(annotationsXml);
                                ExternalAnnotationsManagerImpl.this.myExternalAnotations.put(virtualFile, createdFiles);
                            }
                            ExternalAnnotationsManagerImpl.annotateExternally(listOwner, annotationFQName, annotationsXml, fromFile);
                        }
                    }
                }
            }.execute();
        }
    }

    private void chooseRootAndAnnotateExternally(final PsiModifierListOwner listOwner, final String annotationFQName, final PsiFile fromFile, final Project project, final String packageName, final VirtualFile virtualFile, VirtualFile[] virtualFiles) {
        if (virtualFiles.length > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>("Annotation Roots", virtualFiles){

                public PopupStep onChosen(VirtualFile file, boolean finalChoice) {
                    ExternalAnnotationsManagerImpl.this.annotateExternally(file, listOwner, project, packageName, virtualFile, annotationFQName, fromFile);
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(VirtualFile value) {
                    String string = value.getPresentableUrl();
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExternalAnnotationsManagerImpl$4.getTextFor must not return null");
                    }
                    return string;
                }

                public Icon getIconFor(VirtualFile aValue) {
                    return ICON;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else {
            this.annotateExternally(virtualFiles[0], listOwner, project, packageName, virtualFile, annotationFQName, fromFile);
        }
    }

    private void annotateExternally(final VirtualFile file, final PsiModifierListOwner listOwner, Project project, final String packageName, final VirtualFile virtualFile, final String annotationFQName, final PsiFile fromFile) {
        final XmlFile[] annotationsXml = new XmlFile[1];
        List<XmlFile> xmlFiles = this.findExternalAnnotationsFile(listOwner);
        if (xmlFiles != null) {
            for (XmlFile xmlFile : xmlFiles) {
                VirtualFile vXmlFile = xmlFile.getVirtualFile();
                assert (vXmlFile != null);
                if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)vXmlFile, (boolean)false)) continue;
                annotationsXml[0] = xmlFile;
                if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{xmlFile.getVirtualFile()}).hasReadonlyFiles()) continue;
                return;
            }
        } else {
            xmlFiles = new ArrayList<XmlFile>();
        }
        final ArrayList<XmlFile> annotationFiles = new ArrayList<XmlFile>(xmlFiles);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                if (annotationsXml[0] == null) {
                    annotationsXml[0] = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(file, packageName);
                }
                if (annotationsXml[0] != null) {
                    annotationFiles.add(annotationsXml[0]);
                    ExternalAnnotationsManagerImpl.this.myExternalAnotations.put(virtualFile, annotationFiles);
                    ExternalAnnotationsManagerImpl.annotateExternally(listOwner, annotationFQName, annotationsXml[0], fromFile);
                }
            }
        }.execute();
    }

    public boolean deannotate(PsiModifierListOwner listOwner, String annotationFQN) {
        List<XmlFile> files = this.findExternalAnnotationsFile(listOwner);
        if (files != null) {
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false);
                String oldExternalName = ExternalAnnotationsManagerImpl.getNormalizedExternalName(listOwner);
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className = tag.getAttributeValue("name");
                    if (!Comparing.strEqual((String)className, (String)externalName) && !Comparing.strEqual((String)className, (String)oldExternalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                        if (ReadonlyStatusHandler.getInstance((Project)file.getProject()).ensureFilesWritable(new VirtualFile[]{file.getVirtualFile()}).hasReadonlyFiles()) {
                            return false;
                        }
                        try {
                            annotationTag.delete();
                            if (tag.getSubTags().length == 0) {
                                tag.delete();
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        MyExternalPromptDialog dialog;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExternalAnnotationsManagerImpl.chooseAnnotationsPlace must not be null");
        }
        if (!element.isPhysical()) {
            return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
        }
        if (!element.getManager().isInProject(element)) {
            return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
        }
        Project project = element.getProject();
        PsiFile containingFile = element.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
        if (!entries.isEmpty()) {
            for (OrderEntry entry : entries) {
                if (entry instanceof ModuleOrderEntry) continue;
                if (AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) break;
                return ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
            }
        }
        MyExternalPromptDialog myExternalPromptDialog = dialog = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MyExternalPromptDialog(project);
        if (dialog != null && dialog.isToBeShown()) {
            PsiElement highlightElement = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : element.getNavigationElement();
            LOG.assertTrue(highlightElement != null);
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            ArrayList highlighters = new ArrayList();
            boolean highlight = editor != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
            try {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace;
                if (highlight) {
                    EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                    TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                    TextRange textRange = highlightElement.getTextRange();
                    HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, highlighters);
                    LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
                    editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
                }
                dialog.show();
                if (dialog.getExitCode() == 2) {
                    annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                    return annotationPlace;
                }
                if (dialog.getExitCode() == 1) {
                    annotationPlace = ExternalAnnotationsManager.AnnotationPlace.NOWHERE;
                    return annotationPlace;
                }
            }
            finally {
                if (highlight) {
                    HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, (RangeHighlighter)highlighters.get(0));
                }
            }
        }
        return ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    private void appendChosenAnnotationsRoot(OrderEntry entry, VirtualFile vFile) {
        if (entry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LOG.assertTrue(library != null);
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(vFile, AnnotationOrderRootType.getInstance());
            model.commit();
            rootModel.commit();
        } else if (entry instanceof ModuleSourceOrderEntry) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            model.setRootUrls(AnnotationOrderRootType.getInstance(), (String[])ArrayUtil.mergeArrays((Object[])model.getRootUrls(AnnotationOrderRootType.getInstance()), (Object[])new String[]{vFile.getUrl()}, String.class));
            model.commit();
        } else if (entry instanceof JdkOrderEntry) {
            SdkModificator sdkModificator = ((JdkOrderEntry)entry).getJdk().getSdkModificator();
            sdkModificator.addRoot(vFile, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        this.myExternalAnotations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void annotateExternally(PsiModifierListOwner listOwner, String annotationFQName, @Nullable XmlFile xmlFile, PsiFile codeUsageFile) {
        if (xmlFile == null) {
            return;
        }
        try {
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag rootTag = document.getRootTag();
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false);
                if (rootTag != null) {
                    for (XmlTag tag : rootTag.getSubTags()) {
                        if (!Comparing.strEqual((String)tag.getAttributeValue("name"), (String)externalName)) continue;
                        tag.add((PsiElement)XmlElementFactory.getInstance((Project)xmlFile.getProject()).createTagFromText("<annotation name='" + annotationFQName + "'/>"));
                        return;
                    }
                    String text = "<item name='" + externalName + "'>\n" + "  <annotation name='" + annotationFQName + "'/>\n" + "</item>";
                    rootTag.add((PsiElement)XmlElementFactory.getInstance((Project)xmlFile.getProject()).createTagFromText(text));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (codeUsageFile.getVirtualFile().isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)codeUsageFile);
            }
        }
    }

    @Nullable
    private XmlFile createAnnotationsXml(VirtualFile root, String packageName) {
        String[] dirs;
        for (String dir : dirs = packageName.split("[\\.]")) {
            if (dir.length() == 0) break;
            VirtualFile subdir = root.findChild(dir);
            if (subdir == null) {
                try {
                    subdir = root.createChildDirectory(null, dir);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            root = subdir;
        }
        PsiDirectory directory = this.myPsiManager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        PsiFile psiFile = directory.findFile("annotations.xml");
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        try {
            return (XmlFile)directory.add((PsiElement)PsiFileFactory.getInstance((Project)this.myPsiManager.getProject()).createFileFromText("annotations.xml", "<root></root>"));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private List<XmlFile> findExternalAnnotationsFile(PsiModifierListOwner listOwner) {
        Project project = listOwner.getProject();
        PsiFile containingFile = listOwner.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            VirtualFile virtualFile = containingFile.getVirtualFile();
            List<XmlFile> files = this.myExternalAnotations.get(virtualFile);
            if (files == NULL) {
                return null;
            }
            if (files != null) {
                Iterator<XmlFile> it = files.iterator();
                while (it.hasNext()) {
                    if (it.next().isValid()) continue;
                    it.remove();
                }
                return files;
            }
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            String packageName = javaFile.getPackageName();
            if (virtualFile != null) {
                List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
                for (OrderEntry entry : entries) {
                    String[] externalUrls;
                    if (entry instanceof ModuleOrderEntry) continue;
                    ArrayList<XmlFile> possibleAnnotationsXmls = null;
                    for (String url : externalUrls = AnnotationOrderRootType.getUrls((OrderEntry)entry)) {
                        PsiFile psiFile;
                        VirtualFile ext = LocalFileSystem.getInstance().findFileByPath(VfsUtil.urlToPath((String)url) + "/" + packageName.replace(".", "/") + "/" + "annotations.xml");
                        if (ext == null || !((psiFile = this.myPsiManager.findFile(ext)) instanceof XmlFile)) continue;
                        if (possibleAnnotationsXmls == null) {
                            possibleAnnotationsXmls = new ArrayList<XmlFile>();
                        }
                        possibleAnnotationsXmls.add((XmlFile)psiFile);
                    }
                    if (possibleAnnotationsXmls == null) break;
                    this.myExternalAnotations.put(virtualFile, possibleAnnotationsXmls);
                    return possibleAnnotationsXmls;
                }
                this.myExternalAnotations.put(virtualFile, NULL);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getNormalizedExternalName(PsiModifierListOwner owner) {
        String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)owner);
        if (externalName != null) {
            int idx;
            PsiMethod method;
            if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class)) != null) {
                externalName = externalName.substring(0, externalName.lastIndexOf(32) + 1) + method.getParameterList().getParameterIndex((PsiParameter)owner);
            }
            if ((idx = externalName.indexOf(40)) == -1) {
                return externalName;
            }
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                int rightIdx = externalName.indexOf(41);
                String[] params = externalName.substring(idx + 1, rightIdx).split(",");
                buf.append(externalName.substring(0, idx + 1));
                for (String param : params) {
                    int spaceIdx = (param = param.trim()).indexOf(32);
                    buf.append(spaceIdx > -1 ? param.substring(0, spaceIdx) : param).append(", ");
                }
                String string = StringUtil.trimEnd((String)buf.toString(), (String)", ") + externalName.substring(rightIdx);
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        return externalName;
    }

    private static class MyExternalPromptDialog
    extends OptionsMessageDialog {
        private final Project myProject;
        private static final String ADD_IN_CODE = ProjectBundle.message((String)"external.annotations.in.code.option", (Object[])new Object[0]);
        private static final String MESSAGE = ProjectBundle.message((String)"external.annotations.suggestion.message", (Object[])new Object[0]);

        public MyExternalPromptDialog(Project project) {
            super(project, MESSAGE, ProjectBundle.message((String)"external.annotation.prompt", (Object[])new Object[0]), Messages.getQuestionIcon());
            this.myProject = project;
            this.init();
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
        }

        protected String getOkActionName() {
            return ADD_IN_CODE;
        }

        protected String getCancelActionName() {
            return CommonBundle.getCancelButtonText();
        }

        protected Action[] createActions() {
            Action okAction = this.getOKAction();
            MyExternalPromptDialog.assignMnemonic((String)ADD_IN_CODE, (Action)okAction);
            final String externalName = ProjectBundle.message((String)"external.annotations.external.option", (Object[])new Object[0]);
            return new Action[]{okAction, new AbstractAction(externalName){
                {
                    super(x0);
                    MyExternalPromptDialog.assignMnemonic((String)externalName, (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyExternalPromptDialog.this.canBeHidden()) {
                        MyExternalPromptDialog.this.setToBeShown(MyExternalPromptDialog.this.toBeShown(), true);
                    }
                    MyExternalPromptDialog.this.close(2);
                }
            }, this.getCancelAction()};
        }

        protected boolean isToBeShown() {
            return CodeStyleSettingsManager.getSettings((Project)this.myProject).USE_EXTERNAL_ANNOTATIONS;
        }

        protected void setToBeShown(boolean value, boolean onOk) {
            CodeStyleSettingsManager.getSettings((Project)this.myProject).USE_EXTERNAL_ANNOTATIONS = value;
        }

        protected JComponent createNorthPanel() {
            JPanel northPanel = (JPanel)super.createNorthPanel();
            northPanel.add((Component)new JLabel(MESSAGE), "Center");
            return northPanel;
        }

        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }
    }
}

