/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanExpressionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = new SimplifyBooleanExpressionFix(null, null).getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction.isAvailable must not be null");
        }
        PsiExpression expression = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file);
        return expression != null && SimplifyBooleanExpressionFix.canBeSimplified(expression);
    }

    private static PsiExpression getExpressionToSimplify(Editor editor, PsiFile file) {
        PsiExpression expression;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiExpression parent = expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        while (parent instanceof PsiExpression && (PsiType.BOOLEAN.equals(parent.getType()) || parent instanceof PsiConditionalExpression)) {
            expression = parent;
            parent = parent.getParent();
        }
        return expression;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SimplifyBooleanExpressionAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiExpression expression = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file);
        SimplifyBooleanExpressionFix.simplifyExpression(expression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

