/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GosubInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnFromSubInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    private static final int NOT_FOUND = -10;
    private ControlFlow myPass1Flow;
    private ControlFlow myCurrentFlow;
    private int myPassNumber;
    private HashSet<DfaVariableValue> myFields;
    private Stack<CatchDescriptor> myCatchStack;
    private PsiType myRuntimeException;
    private final DfaValueFactory myFactory;
    private boolean myHonorRuntimeExceptions = true;
    private boolean myRecursionStopper = false;

    ControlFlowAnalyzer(DfaValueFactory valueFactory) {
        this.myFactory = valueFactory;
    }

    public void setHonorRuntimeExceptions(boolean honorRuntimeExceptions) {
        this.myHonorRuntimeExceptions = honorRuntimeExceptions;
    }

    public ControlFlow buildControlFlow(PsiElement codeFragment) {
        ControlFlow pass2Flow;
        if (codeFragment == null) {
            return null;
        }
        this.myRuntimeException = PsiType.getJavaLangRuntimeException((PsiManager)codeFragment.getManager(), (GlobalSearchScope)codeFragment.getResolveScope());
        this.myFields = new HashSet();
        this.myCatchStack = new Stack();
        this.myPassNumber = 1;
        this.myCurrentFlow = this.myPass1Flow = new ControlFlow(this.myFactory);
        try {
            codeFragment.accept((PsiElementVisitor)this);
        }
        catch (CantAnalyzeException e) {
            return null;
        }
        this.myPassNumber = 2;
        this.myCurrentFlow = pass2Flow = new ControlFlow(this.myFactory);
        codeFragment.accept((PsiElementVisitor)this);
        pass2Flow.setFields(this.myFields.toArray(new DfaVariableValue[this.myFields.size()]));
        LOG.assertTrue(this.myPass1Flow.getInstructionCount() == pass2Flow.getInstructionCount());
        this.addInstruction(new ReturnInstruction());
        return pass2Flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstruction(Instruction instruction) {
        ProgressManager.checkCanceled();
        if (!this.myRecursionStopper) {
            this.myRecursionStopper = true;
            try {
                if (instruction instanceof BranchingInstruction || instruction instanceof AssignInstruction || instruction instanceof MethodCallInstruction) {
                    this.addConditionalRuntimeThrow();
                }
            }
            finally {
                this.myRecursionStopper = false;
            }
        }
        this.myCurrentFlow.addInstruction(instruction);
    }

    private int getEndOffset(PsiElement element) {
        return this.myPassNumber == 2 ? this.myPass1Flow.getEndOffset(element) : 0;
    }

    private int getStartOffset(PsiElement element) {
        return this.myPassNumber == 2 ? this.myPass1Flow.getStartOffset(element) : 0;
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        this.startElement((PsiElement)expression);
        try {
            PsiExpression lExpr = expression.getLExpression();
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                this.pushUnknown();
                return;
            }
            lExpr.accept((PsiElementVisitor)this);
            IElementType op = expression.getOperationSign().getTokenType();
            PsiType type = expression.getType();
            boolean isBoolean = PsiType.BOOLEAN.equals(type);
            if (op == JavaTokenType.EQ) {
                rExpr.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(rExpr, type);
            } else if (op == JavaTokenType.ANDEQ) {
                if (isBoolean) {
                    this.generateNonMaccartyExpression(true, lExpr, rExpr, type);
                } else {
                    this.generateDefaultBinop(lExpr, rExpr, type);
                }
            } else if (op == JavaTokenType.OREQ) {
                if (isBoolean) {
                    this.generateNonMaccartyExpression(false, lExpr, rExpr, type);
                } else {
                    this.generateDefaultBinop(lExpr, rExpr, type);
                }
            } else if (op == JavaTokenType.XOREQ) {
                if (isBoolean) {
                    this.generateXorExpression((PsiExpression)expression, lExpr, rExpr, type);
                } else {
                    this.generateDefaultBinop(lExpr, rExpr, type);
                }
            } else {
                this.generateDefaultBinop(lExpr, rExpr, type);
            }
            this.addInstruction(new AssignInstruction(rExpr));
        }
        finally {
            this.finishElement((PsiElement)expression);
        }
    }

    private void generateDefaultBinop(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, lExpr.getProject()));
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, (PsiElement)condition));
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.addInstruction(new ReturnInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                element.accept((PsiElementVisitor)this);
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement((PsiElement)statement);
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().create(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer));
        this.addInstruction(new PopInstruction());
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement((PsiElement)block);
        for (PsiStatement statement : statements = block.getStatements()) {
            statement.accept((PsiElementVisitor)this);
        }
        for (PsiStatement statement : statements) {
            PsiElement[] declarations;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            for (PsiElement declaration : declarations = declarationStatement.getDeclaredElements()) {
                if (!(declaration instanceof PsiVariable)) continue;
                this.myCurrentFlow.removeVariable((PsiVariable)declaration);
            }
        }
        this.finishElement((PsiElement)block);
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement((PsiElement)statement);
        statement.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            int offset = this.myPass1Flow.getEndOffset((PsiElement)exitedStatement);
            if (offset == -1) {
                offset = this.myPass1Flow.getInstructionCount();
            }
            this.addInstruction(new GotoInstruction(offset));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement != null) {
            PsiStatement body;
            int offset = -1;
            if (continuedStatement instanceof PsiForStatement) {
                body = ((PsiForStatement)continuedStatement).getBody();
                offset = this.myPass1Flow.getEndOffset((PsiElement)body);
            } else if (continuedStatement instanceof PsiWhileStatement) {
                body = ((PsiWhileStatement)continuedStatement).getBody();
                offset = this.myPass1Flow.getEndOffset((PsiElement)body);
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                body = ((PsiDoWhileStatement)continuedStatement).getBody();
                offset = this.myPass1Flow.getEndOffset((PsiElement)body);
            } else if (continuedStatement instanceof PsiForeachStatement) {
                body = ((PsiForeachStatement)continuedStatement).getBody();
                offset = this.myPass1Flow.getEndOffset((PsiElement)body);
            }
            Instruction instruction = offset == -1 ? new EmptyInstruction() : new GotoInstruction(offset);
            this.addInstruction(instruction);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement), false, (PsiElement)condition));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction(new PopInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        this.startElement((PsiElement)statement);
        PsiParameter parameter = statement.getIterationParameter();
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(iteratedValue, "Collection iterator or array.length"));
        }
        int offset = this.myCurrentFlow.getInstructionCount();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().create((PsiVariable)parameter, false);
        this.addInstruction(new PushInstruction(dfaVariable, null));
        this.pushUnknown();
        this.addInstruction(new AssignInstruction(null));
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, null));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        this.myCurrentFlow.removeVariable((PsiVariable)parameter);
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update;
        PsiExpression condition;
        this.startElement((PsiElement)statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    this.visitElement((PsiElement)expression);
                }

                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if ((update = statement.getUpdate()) != null) {
            update.accept((PsiElementVisitor)this);
        }
        int offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    public void visitIfStatement(PsiIfStatement statement) {
        int offset;
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        int n = offset = elseStatement != null ? this.getStartOffset((PsiElement)elseStatement) : this.getEndOffset((PsiElement)statement);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, (PsiElement)condition));
        }
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset((PsiElement)statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitStatement(PsiStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        int finallyOffset;
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (returnValue != null) {
            returnValue.accept((PsiElementVisitor)this);
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (method != null) {
                this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
            }
            this.addInstruction(new CheckReturnValueInstruction(statement));
        }
        if ((finallyOffset = this.getFinallyOffset()) != -10) {
            this.addInstruction(new GosubInstruction(finallyOffset));
        }
        this.addInstruction(new ReturnInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body;
        this.startElement((PsiElement)switchStmt);
        PsiElementFactory psiFactory = JavaPsiFacade.getInstance((Project)switchStmt.getProject()).getElementFactory();
        PsiExpression caseExpression = switchStmt.getExpression();
        if (caseExpression != null) {
            caseExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, PsiType.INT);
            if (TypeConversionUtil.isEnumType((PsiType)caseExpression.getType())) {
                this.addInstruction(new FieldReferenceInstruction(caseExpression, "switch statement expression"));
            }
            this.addInstruction(new PopInstruction());
        }
        if ((body = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    int offset = this.getStartOffset((PsiElement)statement);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null && JavaPsiFacade.getInstance((Project)body.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)caseValue) != null) {
                        PsiExpression psiComparison = psiFactory.createExpressionFromText(caseExpression.getText() + "==" + caseValue.getText(), (PsiElement)switchStmt);
                        psiComparison.accept((PsiElementVisitor)this);
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, (PsiElement)statement));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            int offset = defaultLabel != null ? this.getStartOffset((PsiElement)defaultLabel) : this.getEndOffset((PsiElement)body);
            this.addInstruction(new GotoInstruction(offset));
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            this.addThrowCode(exception.getType());
        }
        this.finishElement((PsiElement)statement);
    }

    private void addConditionalRuntimeThrow() {
        for (int i = this.myCatchStack.size() - 1; i >= 0; --i) {
            ConditionalGotoInstruction branch;
            CatchDescriptor cd = (CatchDescriptor)this.myCatchStack.get(i);
            if (cd.isFinally()) {
                this.pushUnknown();
                branch = new ConditionalGotoInstruction(-1, false, null);
                this.addInstruction(branch);
                this.addInstruction(new GosubInstruction(cd.getJumpOffset()));
                this.addInstruction(new ReturnInstruction());
                branch.setOffset(this.myCurrentFlow.getInstructionCount());
                continue;
            }
            if (!(cd.getType() instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)cd.getType())) continue;
            this.pushUnknown();
            branch = new ConditionalGotoInstruction(-1, false, null);
            this.addInstruction(branch);
            this.addInstruction(new PushInstruction(this.myFactory.getNotNullFactory().create(this.myRuntimeException), null));
            this.addGotoCatch(cd);
            branch.setOffset(this.myCurrentFlow.getInstructionCount());
            return;
        }
    }

    private void addThrowCode(PsiType exceptionClass) {
        if (exceptionClass == null) {
            return;
        }
        for (int i = this.myCatchStack.size() - 1; i >= 0; --i) {
            CatchDescriptor cd = (CatchDescriptor)this.myCatchStack.get(i);
            if (cd.isFinally()) {
                this.addInstruction(new GosubInstruction(cd.getJumpOffset()));
                continue;
            }
            if (cd.getType().isAssignableFrom(exceptionClass)) {
                this.addGotoCatch(cd);
                return;
            }
            if (!cd.getType().isConvertibleFrom(exceptionClass)) continue;
            this.addInstruction(new DupInstruction());
            this.pushUnknown();
            ConditionalGotoInstruction branch = new ConditionalGotoInstruction(-1, false, null);
            this.addInstruction(branch);
            this.addGotoCatch(cd);
            branch.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        this.addInstruction(new ReturnInstruction());
    }

    private void addGotoCatch(CatchDescriptor cd) {
        this.addInstruction(new PushInstruction(this.myFactory.getVarFactory().create((PsiVariable)cd.getParameter(), false), null));
        this.addInstruction(new SwapInstruction());
        this.addInstruction(new AssignInstruction(null));
        this.addInstruction(new PopInstruction());
        this.addInstruction(new GotoInstruction(cd.getJumpOffset()));
    }

    private int getFinallyOffset() {
        for (int i = this.myCatchStack.size() - 1; i >= 0; --i) {
            CatchDescriptor cd = (CatchDescriptor)this.myCatchStack.get(i);
            if (!cd.isFinally()) continue;
            return cd.getJumpOffset();
        }
        return -10;
    }

    public void visitErrorElement(PsiErrorElement element) {
        throw new CantAnalyzeException();
    }

    public void visitTryStatement(PsiTryStatement statement) {
        this.startElement((PsiElement)statement);
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        if (finallyBlock != null) {
            this.myCatchStack.push(new CatchDescriptor(finallyBlock));
        }
        int catchesPushCount = 0;
        PsiCatchSection[] sections = statement.getCatchSections();
        for (int i = sections.length - 1; i >= 0; --i) {
            PsiCatchSection section = sections[i];
            PsiCodeBlock catchBlock = section.getCatchBlock();
            PsiParameter parameter = section.getParameter();
            if (!(parameter == null || catchBlock == null || !(parameter.getType() instanceof PsiClassType) || this.myHonorRuntimeExceptions && ExceptionUtil.isUncheckedException((PsiClassType)parameter.getType()))) {
                this.myCatchStack.push(new CatchDescriptor(parameter, catchBlock));
                ++catchesPushCount;
                continue;
            }
            throw new CantAnalyzeException();
        }
        int endOffset = finallyBlock == null ? this.getEndOffset((PsiElement)statement) : this.getStartOffset((PsiElement)finallyBlock) - 2;
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        for (int i = 0; i < catchesPushCount; ++i) {
            this.myCatchStack.pop();
        }
        this.addInstruction(new GotoInstruction(endOffset));
        for (PsiCatchSection section : sections) {
            section.accept((PsiElementVisitor)this);
            this.addInstruction(new GotoInstruction(endOffset));
        }
        if (finallyBlock != null) {
            this.myCatchStack.pop();
            this.addInstruction(new GosubInstruction(this.getStartOffset((PsiElement)finallyBlock)));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)statement)));
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(new ReturnFromSubInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitCatchSection(PsiCatchSection section) {
        PsiCodeBlock catchBlock = section.getCatchBlock();
        if (catchBlock != null) {
            catchBlock.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        PsiStatement body;
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition));
        }
        if ((body = statement.getBody()) != null) {
            body.accept((PsiElementVisitor)this);
        }
        if (condition != null) {
            this.addInstruction(new GotoInstruction(this.getStartOffset((PsiElement)statement)));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions;
        this.startElement((PsiElement)list);
        for (PsiExpression expression : expressions = list.getExpressions()) {
            expression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(PsiExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.create(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression arrayExpression = expression.getArrayExpression();
        arrayExpression.accept((PsiElementVisitor)this);
        this.addInstruction(new FieldReferenceInstruction((PsiExpression)expression, null));
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, PsiType.INT);
            this.addInstruction(new PopInstruction());
        }
        this.pushTypeOrUnknown(arrayExpression);
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression);
        PsiType type = expression.getType();
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            initializer.accept((PsiElementVisitor)this);
            if (type instanceof PsiArrayType) {
                this.generateBoxingUnboxingInstructionFor(initializer, ((PsiArrayType)type).getComponentType());
            }
            this.addInstruction(new PopInstruction());
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBinaryExpression(PsiBinaryExpression expression) {
        this.startElement((PsiElement)expression);
        try {
            DfaValue dfaValue = this.myFactory.create((PsiExpression)expression);
            if (dfaValue != null) {
                this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
            } else {
                IElementType op = expression.getOperationSign().getTokenType();
                PsiExpression lExpr = expression.getLOperand();
                PsiExpression rExpr = expression.getROperand();
                if (rExpr == null) {
                    this.pushUnknown();
                    return;
                }
                PsiType type = expression.getType();
                if (op == JavaTokenType.ANDAND) {
                    this.generateAndExpression(lExpr, rExpr, type);
                } else if (op == JavaTokenType.OROR) {
                    this.generateOrExpression(lExpr, rExpr, type);
                } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals(type)) {
                    this.generateXorExpression((PsiExpression)expression, lExpr, rExpr, type);
                } else {
                    String opSign;
                    PsiType castType;
                    lExpr.accept((PsiElementVisitor)this);
                    boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
                    PsiType lType = lExpr.getType();
                    PsiType rType = rExpr.getType();
                    boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
                    boolean comparingPrimitiveNumerics = comparing && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
                    PsiType psiType = castType = comparingPrimitiveNumerics ? PsiType.LONG : type;
                    if (!comparingRef) {
                        this.generateBoxingUnboxingInstructionFor(lExpr, castType);
                    }
                    rExpr.accept((PsiElementVisitor)this);
                    if (!comparingRef) {
                        this.generateBoxingUnboxingInstructionFor(rExpr, castType);
                    }
                    if ("+".equals(opSign = expression.getOperationSign().getText()) && (type == null || !type.equalsToText("java.lang.String"))) {
                        opSign = null;
                    }
                    PsiBinaryExpression psiAnchor = expression.isPhysical() ? expression : null;
                    this.addInstruction(new BinopInstruction(opSign, (PsiElement)psiAnchor, expression.getProject()));
                }
            }
        }
        finally {
            this.finishElement((PsiElement)expression);
        }
    }

    private void generateBoxingUnboxingInstructionFor(PsiExpression expression, PsiType expectedType) {
        PsiType exprType = expression.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)exprType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.UNBOXING));
        } else if (TypeConversionUtil.isPrimitiveWrapper((PsiType)expectedType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.BOXING));
        } else if (exprType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)exprType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression, PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        PsiExpression psiAnchor = expression.isPhysical() ? expression : null;
        this.addInstruction(new BinopInstruction("!=", (PsiElement)psiAnchor, expression.getProject()));
    }

    private void generateOrExpression(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)rExpr), true, (PsiElement)lExpr));
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)rExpr)));
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
    }

    private void generateNonMaccartyExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        rExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        lExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(-1, and, (PsiElement)lExpression);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(-1);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        PushInstruction pushSuccess = new PushInstruction(and ? this.myFactory.getConstFactory().getFalse() : this.myFactory.getConstFactory().getTrue(), null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        ConditionalGotoInstruction firstTrueGoto = new ConditionalGotoInstruction(-1, true, (PsiElement)lExpr);
        this.addInstruction(firstTrueGoto);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        GotoInstruction overPushFalse = new GotoInstruction(-1);
        this.addInstruction(overPushFalse);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        firstTrueGoto.setOffset(pushFalse.getIndex());
        overPushFalse.setOffset(pushFalse.getIndex() + 1);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        PsiElement[] children;
        this.startElement((PsiElement)expression);
        for (PsiElement child : children = expression.getChildren()) {
            child.accept((PsiElementVisitor)this);
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.create((PsiExpression)expression);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        } else {
            int elseOffset;
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            int n = elseOffset = elseExpression == null ? this.getEndOffset((PsiElement)expression) - 1 : this.getStartOffset((PsiElement)elseExpression);
            if (thenExpression != null) {
                condition.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
                PsiType type = expression.getType();
                this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, (PsiElement)condition));
                thenExpression.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(thenExpression, type);
                this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression)));
                if (elseExpression != null) {
                    elseExpression.accept((PsiElementVisitor)this);
                    this.generateBoxingUnboxingInstructionFor(elseExpression, type);
                } else {
                    this.pushUnknown();
                }
            } else {
                this.pushUnknown();
            }
        }
        this.finishElement((PsiElement)expression);
    }

    private void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            operand.accept((PsiElementVisitor)this);
            PsiType type = checkType.getType();
            if (type instanceof PsiClassType) {
                type = ((PsiClassType)type).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.getTypeFactory().create(type), null));
            this.addInstruction(new InstanceofInstruction((PsiElement)expression, expression.getProject(), operand, type));
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    private void addMethodThrows(PsiMethod method) {
        if (method != null) {
            PsiClassType[] refs;
            for (PsiClassType ref : refs = method.getThrowsList().getReferencedTypes()) {
                this.pushUnknown();
                ConditionalGotoInstruction cond = new ConditionalGotoInstruction(-10, false, null);
                this.addInstruction(cond);
                this.addInstruction(new EmptyStackInstruction());
                this.addInstruction(new PushInstruction(this.myFactory.getTypeFactory().create((PsiType)ref), null));
                this.addThrowCode((PsiType)ref);
                cond.setOffset(this.myCurrentFlow.getInstructionCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        try {
            this.startElement((PsiElement)expression);
            if (this.processSpecialMethods(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                qualifierExpression.accept((PsiElementVisitor)this);
            } else {
                this.pushUnknown();
            }
            PsiExpression[] paramExprs = expression.getArgumentList().getExpressions();
            PsiElement method = methodExpression.resolve();
            PsiParameter[] parameters = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
            for (int i = 0; i < paramExprs.length; ++i) {
                PsiExpression paramExpr = paramExprs[i];
                paramExpr.accept((PsiElementVisitor)this);
                if (parameters == null || i >= parameters.length) continue;
                this.generateBoxingUnboxingInstructionFor(paramExpr, parameters[i].getType());
            }
            this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression));
            if (!this.myCatchStack.isEmpty()) {
                this.addMethodThrows(expression.resolveMethod());
            }
        }
        finally {
            this.finishElement((PsiElement)expression);
        }
    }

    private boolean processSpecialMethods(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        PsiMethod resolved = expression.resolveMethod();
        if (resolved != null) {
            PsiType qualifierType;
            PsiExpressionList argList = expression.getArgumentList();
            String methodName = resolved.getName();
            PsiExpression[] params = argList.getExpressions();
            PsiClass owner = resolved.getContainingClass();
            int exitPoint = this.getEndOffset((PsiElement)expression) - 1;
            if (owner != null) {
                String className = owner.getQualifiedName();
                if ("java.lang.System".equals(className)) {
                    if ("exit".equals(methodName)) {
                        this.pushParameters(params, false, false);
                        this.addInstruction(new ReturnInstruction());
                        return true;
                    }
                } else if ("junit.framework.Assert".equals(className) || "org.junit.Assert".equals(className) || "org.testng.Assert".equals(className)) {
                    boolean testng = "org.testng.Assert".equals(className);
                    if ("fail".equals(methodName)) {
                        this.pushParameters(params, false, !testng);
                        this.addInstruction(new ReturnInstruction());
                        return true;
                    }
                    if ("assertTrue".equals(methodName)) {
                        this.pushParameters(params, true, !testng);
                        this.conditionalExit(exitPoint, false);
                        return true;
                    }
                    if ("assertFalse".equals(methodName)) {
                        this.pushParameters(params, true, !testng);
                        this.conditionalExit(exitPoint, true);
                        return true;
                    }
                    if ("assertNull".equals(methodName)) {
                        this.pushParameters(params, true, !testng);
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
                        this.addInstruction(new BinopInstruction("==", null, expression.getProject()));
                        this.conditionalExit(exitPoint, false);
                        return true;
                    }
                    if ("assertNotNull".equals(methodName)) {
                        this.pushParameters(params, true, !testng);
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
                        this.addInstruction(new BinopInstruction("==", null, expression.getProject()));
                        this.conditionalExit(exitPoint, true);
                        return true;
                    }
                    return false;
                }
            }
            if (qualifierExpression != null && qualifierExpression.textMatches((CharSequence)"LOG") && (qualifierType = qualifierExpression.getType()) != null && qualifierType.equalsToText("com.intellij.openapi.diagnostic.Logger")) {
                if ("error".equals(methodName)) {
                    for (PsiExpression param : params) {
                        param.accept((PsiElementVisitor)this);
                        this.addInstruction(new PopInstruction());
                    }
                    this.addInstruction(new ReturnInstruction());
                    return true;
                }
                if ("assertTrue".equals(methodName)) {
                    params[0].accept((PsiElementVisitor)this);
                    for (int i = 1; i < params.length; ++i) {
                        params[i].accept((PsiElementVisitor)this);
                        this.addInstruction(new PopInstruction());
                    }
                    this.conditionalExit(exitPoint, false);
                    return true;
                }
            }
        }
        return false;
    }

    private void conditionalExit(int continuePoint, boolean exitIfTrue) {
        this.addInstruction(new ConditionalGotoInstruction(continuePoint, exitIfTrue, null));
        this.addInstruction(new ReturnInstruction());
        this.pushUnknown();
    }

    private void pushParameters(PsiExpression[] params, boolean leaveOnStack, boolean lastParameterIsSignificant) {
        for (int i = 0; i < params.length; ++i) {
            PsiExpression param = params[i];
            param.accept((PsiElementVisitor)this);
            if (leaveOnStack && (lastParameterIsSignificant && i == params.length - 1 || !lastParameterIsSignificant && i == 0)) continue;
            this.addInstruction(new PopInstruction());
        }
    }

    private void pushTypeOrUnknown(PsiExpression expr) {
        PsiType type = expr.getType();
        DfaTypeValue dfaValue = type instanceof PsiClassType ? this.myFactory.getTypeFactory().create(type) : null;
        this.addInstruction(new PushInstruction(dfaValue, null));
    }

    public void visitNewExpression(PsiNewExpression expression) {
        this.startElement((PsiElement)expression);
        this.pushUnknown();
        if (expression.getType() instanceof PsiArrayType) {
            PsiExpression[] dimensions;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                dimension.accept((PsiElementVisitor)this);
            }
            for (PsiExpression dimension : dimensions) {
                this.addInstruction(new PopInstruction());
            }
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer != null) {
                for (PsiExpression initializer : arrayInitializer.getInitializers()) {
                    initializer.accept((PsiElementVisitor)this);
                    this.addInstruction(new PopInstruction());
                }
            }
            this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression));
        } else {
            PsiExpressionList args = expression.getArgumentList();
            PsiMethod ctr = expression.resolveConstructor();
            if (args != null) {
                PsiExpression[] params = args.getExpressions();
                PsiParameter[] parameters = ctr == null ? null : ctr.getParameterList().getParameters();
                for (int i = 0; i < params.length; ++i) {
                    PsiExpression param = params[i];
                    param.accept((PsiElementVisitor)this);
                    if (parameters == null || i >= parameters.length) continue;
                    this.generateBoxingUnboxingInstructionFor(param, parameters[i].getType());
                }
            }
            this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression));
            if (!this.myCatchStack.isEmpty()) {
                this.addMethodThrows(ctr);
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression inner = expression.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        PsiVariable psiVariable;
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        operand.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(operand, PsiType.INT);
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        if (operand instanceof PsiReferenceExpression && (psiVariable = DfaValueFactory.resolveVariable((PsiReferenceExpression)expression.getOperand())) != null) {
            DfaVariableValue dfaVariable = this.myFactory.getVarFactory().create(psiVariable, false);
            this.addInstruction(new FlushVariableInstruction(dfaVariable));
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.create((PsiExpression)expression);
        if (dfaValue == null) {
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                this.pushUnknown();
            } else {
                operand.accept((PsiElementVisitor)this);
                PsiType type = expression.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                this.generateBoxingUnboxingInstructionFor(operand, (PsiType)(unboxed == null ? type : unboxed));
                if (expression.getOperationSign().getTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else {
                    PsiVariable psiVariable;
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    if (operand instanceof PsiReferenceExpression && (psiVariable = DfaValueFactory.resolveVariable((PsiReferenceExpression)operand)) != null) {
                        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().create(psiVariable, false);
                        this.addInstruction(new FlushVariableInstruction(dfaVariable));
                    }
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiExpression qualifierExpression;
        DfaVariableValue dfaVariable;
        PsiVariable psiVariable;
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.create((PsiExpression)expression);
        if (dfaValue instanceof DfaVariableValue && (psiVariable = (dfaVariable = (DfaVariableValue)dfaValue).getPsiVariable()) instanceof PsiField && !psiVariable.hasModifierProperty("final")) {
            this.addField(dfaVariable);
        }
        if ((qualifierExpression = expression.getQualifierExpression()) != null) {
            qualifierExpression.accept((PsiElementVisitor)this);
            if (expression.resolve() instanceof PsiField) {
                this.addInstruction(new FieldReferenceInstruction((PsiExpression)expression, null));
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        this.finishElement((PsiElement)expression);
    }

    private void addField(DfaVariableValue field) {
        this.myFields.add(field);
    }

    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement((PsiElement)expression);
        this.addInstruction(new PushInstruction(this.myFactory.getNotNullFactory().create(expression.getType()), null));
        this.finishElement((PsiElement)expression);
    }

    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement((PsiElement)expression);
        this.addInstruction(new PushInstruction(this.myFactory.getNotNullFactory().create(expression.getType()), null));
        this.finishElement((PsiElement)expression);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.create((PsiExpression)expression);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement((PsiElement)castExpression);
        PsiExpression operand = castExpression.getOperand();
        if (operand != null) {
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, castExpression.getType());
        } else {
            this.pushTypeOrUnknown((PsiExpression)castExpression);
        }
        this.addInstruction(ControlFlowAnalyzer.createCastInstruction(castExpression));
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(PsiClass aClass) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Instruction createCastInstruction(PsiTypeCastExpression castExpression) {
        Instruction instruction;
        PsiExpression expr = castExpression.getOperand();
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && !RedundantCastUtil.isTypeCastSemantical((PsiTypeCastExpression)castExpression)) {
            PsiType castType = typeElement.getType();
            if (expr != null) {
                instruction = new TypeCastInstruction(castExpression, expr, castType);
                if (instruction == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer.createCastInstruction must not return null");
                return instruction;
            }
        }
        if ((instruction = new Instruction(){

            @Override
            public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                stateBefore.pop();
                stateBefore.push(DfaUnknownValue.getInstance());
                return this.nextInstruction(runner, stateBefore);
            }
        }) != null) return instruction;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer.createCastInstruction must not return null");
    }

    class CatchDescriptor {
        private final PsiType myType;
        private PsiParameter myParameter;
        private final PsiCodeBlock myBlock;
        private final boolean myIsFinally;

        CatchDescriptor(PsiCodeBlock finallyBlock) {
            this.myType = null;
            this.myBlock = finallyBlock;
            this.myIsFinally = true;
        }

        CatchDescriptor(PsiParameter parameter, PsiCodeBlock catchBlock) {
            this.myType = parameter.getType();
            this.myParameter = parameter;
            this.myBlock = catchBlock;
            this.myIsFinally = false;
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isFinally() {
            return this.myIsFinally;
        }

        public int getJumpOffset() {
            return ControlFlowAnalyzer.this.getStartOffset((PsiElement)this.myBlock);
        }

        public PsiParameter getParameter() {
            return this.myParameter;
        }
    }

    private static class CantAnalyzeException
    extends RuntimeException {
        private CantAnalyzeException() {
        }
    }
}

