/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestUtil;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefClassImpl
extends RefJavaElementImpl
implements RefClass {
    private static final HashSet<RefElement> EMPTY_SET = new HashSet(0);
    private static final HashSet<RefClass> EMPTY_CLASS_SET = new HashSet(0);
    private static final ArrayList<RefMethod> EMPTY_METHOD_LIST = new ArrayList(0);
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_UTILITY_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_APPLET_MASK = 0x200000;
    private static final int IS_SERVLET_MASK = 0x400000;
    private static final int IS_TESTCASE_MASK = 0x800000;
    private static final int IS_LOCAL_MASK = 0x1000000;
    private HashSet<RefClass> myBases;
    private HashSet<RefClass> mySubClasses;
    private ArrayList<RefMethod> myConstructors;
    private RefMethodImpl myDefaultConstructor;
    private ArrayList<RefMethod> myOverridingMethods;
    private THashSet<RefElement> myInTypeReferences;
    private THashSet<RefElement> myInstanceReferences;
    private ArrayList<RefJavaElement> myClassExporters;

    RefClassImpl(PsiClass psiClass, RefManager manager) {
        super((PsiModifierListOwner)psiClass, manager);
    }

    @Override
    protected void initialize() {
        PsiClass applet;
        this.myDefaultConstructor = null;
        PsiClass psiClass = this.getElement();
        LOG.assertTrue(psiClass != null);
        PsiElement psiParent = psiClass.getParent();
        if (psiParent instanceof PsiFile) {
            if (this.isSyntheticJSP()) {
                RefFileImpl refFile = (RefFileImpl)this.getRefManager().getReference((PsiElement)JspPsiUtil.getJspFile((PsiElement)psiClass));
                LOG.assertTrue(refFile != null);
                refFile.add(this);
            } else if (psiParent instanceof PsiJavaFile) {
                PsiJavaFile psiFile = (PsiJavaFile)psiParent;
                String packageName = psiFile.getPackageName();
                if (!"".equals(packageName)) {
                    ((RefPackageImpl)this.getRefJavaManager().getPackage(packageName)).add(this);
                } else {
                    ((RefPackageImpl)this.getRefJavaManager().getDefaultPackage()).add(this);
                }
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
            LOG.assertTrue(module != null);
            RefModuleImpl refModule = (RefModuleImpl)this.getRefManager().getRefModule(module);
            LOG.assertTrue(refModule != null);
            refModule.add(this);
        } else {
            while (!(psiParent instanceof PsiClass || psiParent instanceof PsiMethod || psiParent instanceof PsiField)) {
                psiParent = psiParent.getParent();
            }
            RefElement refParent = this.getRefManager().getReference(psiParent);
            LOG.assertTrue(refParent != null);
            ((RefElementImpl)refParent).add(this);
        }
        this.setAbstract(psiClass.hasModifierProperty("abstract"));
        this.setAnonymous(psiClass instanceof PsiAnonymousClass);
        this.setIsLocal(!this.isAnonymous() && !(psiParent instanceof PsiClass) && !(psiParent instanceof PsiFile));
        this.setInterface(psiClass.isInterface());
        this.initializeSuperReferences(psiClass);
        PsiMethod[] psiMethods = psiClass.getMethods();
        PsiField[] psiFields = psiClass.getFields();
        this.setUtilityClass(psiMethods.length > 0 || psiFields.length > 0);
        for (PsiField psiField : psiFields) {
            this.getRefManager().getReference((PsiElement)psiField);
        }
        if (!this.isApplet()) {
            PsiClass servlet = this.getRefJavaManager().getServlet();
            this.setServlet(servlet != null && psiClass.isInheritor(servlet, true));
        }
        if (!this.isApplet() && !this.isServlet()) {
            this.setTestCase(TestUtil.isTestClass((PsiClass)psiClass));
            for (RefClass refBase : this.getBaseClasses()) {
                ((RefClassImpl)refBase).setTestCase(true);
            }
        }
        for (PsiField psiField : psiMethods) {
            RefMethod refMethod = (RefMethod)this.getRefManager().getReference((PsiElement)psiField);
            if (refMethod == null) continue;
            if (psiField.isConstructor()) {
                if (psiField.getParameterList().getParametersCount() > 0 || !psiField.hasModifierProperty("private")) {
                    this.setUtilityClass(false);
                }
                this.addConstructor(refMethod);
                if (psiField.getParameterList().getParametersCount() != 0) continue;
                this.setDefaultConstructor((RefMethodImpl)refMethod);
                continue;
            }
            if (psiField.hasModifierProperty("static")) continue;
            this.setUtilityClass(false);
        }
        if (this.getConstructors().size() == 0 && !this.isInterface() && !this.isAnonymous()) {
            RefImplicitConstructorImpl refImplicitConstructor = new RefImplicitConstructorImpl(this);
            this.setDefaultConstructor(refImplicitConstructor);
            this.addConstructor(refImplicitConstructor);
        }
        if (this.isInterface()) {
            for (int i = 0; i < psiFields.length && this.isUtilityClass(); ++i) {
                PsiField psiField = psiFields[i];
                if (psiField.hasModifierProperty("static")) continue;
                this.setUtilityClass(false);
            }
        }
        this.setApplet((applet = this.getRefJavaManager().getApplet()) != null && psiClass.isInheritor(applet, true));
        this.getRefManager().fireNodeInitialized(this);
    }

    private void initializeSuperReferences(PsiClass psiClass) {
        if (!this.isSelfInheritor(psiClass)) {
            for (PsiClass psiSuperClass : psiClass.getSupers()) {
                RefClassImpl refClass;
                if (!this.getRefManager().belongsToScope((PsiElement)psiSuperClass) || (refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)psiSuperClass)) == null) continue;
                this.addBaseClass(refClass);
                refClass.addSubClass(this);
            }
        }
    }

    public boolean isSelfInheritor(PsiClass psiClass) {
        return RefClassImpl.isSelfInheritor(psiClass, new ArrayList<PsiClass>());
    }

    public PsiClass getElement() {
        return (PsiClass)super.getElement();
    }

    private static boolean isSelfInheritor(PsiClass psiClass, ArrayList<PsiClass> visited) {
        if (visited.contains(psiClass)) {
            return true;
        }
        visited.add(psiClass);
        for (PsiClass aSuper : psiClass.getSupers()) {
            if (!RefClassImpl.isSelfInheritor(aSuper, visited)) continue;
            return true;
        }
        visited.remove(psiClass);
        return false;
    }

    private void setDefaultConstructor(RefMethodImpl defaultConstructor) {
        if (defaultConstructor != null) {
            for (RefClass superClass : this.getBaseClasses()) {
                RefMethodImpl superDefaultConstructor = (RefMethodImpl)superClass.getDefaultConstructor();
                if (superDefaultConstructor == null) continue;
                superDefaultConstructor.addInReference(defaultConstructor);
                defaultConstructor.addOutReference(superDefaultConstructor);
            }
        }
        this.myDefaultConstructor = defaultConstructor;
    }

    @Override
    public void buildReferences() {
        PsiClass psiClass = this.getElement();
        if (psiClass != null) {
            PsiMethod[] psiMethods;
            PsiField[] psiFields;
            for (PsiClassInitializer classInitializer : psiClass.getInitializers()) {
                RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)classInitializer.getBody());
            }
            RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)psiClass.getModifierList());
            for (PsiField psiField : psiFields = psiClass.getFields()) {
                this.getRefManager().getReference((PsiElement)psiField);
                PsiExpression initializer = psiField.getInitializer();
                if (initializer == null) continue;
                RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)initializer);
            }
            for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
                this.getRefManager().getReference((PsiElement)psiMethod);
            }
            this.getRefManager().fireBuildReferences(this);
        }
    }

    @Override
    public void accept(final RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ((RefJavaVisitor)visitor).visitClass((RefClass)RefClassImpl.this);
                }
            });
        } else {
            super.accept(visitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public HashSet<RefClass> getBaseClasses() {
        HashSet<RefClass> hashSet;
        if (this.myBases == null) {
            hashSet = EMPTY_CLASS_SET;
            if (hashSet == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getBaseClasses must not return null");
            return hashSet;
        }
        hashSet = this.myBases;
        if (hashSet != null) return hashSet;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getBaseClasses must not return null");
    }

    private void addBaseClass(RefClass refClass) {
        if (this.myBases == null) {
            this.myBases = new HashSet(1);
        }
        this.myBases.add(refClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public HashSet<RefClass> getSubClasses() {
        HashSet<RefClass> hashSet;
        if (this.mySubClasses == null) {
            hashSet = EMPTY_CLASS_SET;
            if (hashSet == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getSubClasses must not return null");
            return hashSet;
        }
        hashSet = this.mySubClasses;
        if (hashSet != null) return hashSet;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getSubClasses must not return null");
    }

    private void addSubClass(RefClass refClass) {
        if (this.mySubClasses == null) {
            this.mySubClasses = new HashSet(1);
        }
        this.mySubClasses.add(refClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ArrayList<RefMethod> getConstructors() {
        ArrayList<RefMethod> arrayList;
        if (this.myConstructors == null) {
            arrayList = EMPTY_METHOD_LIST;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getConstructors must not return null");
            return arrayList;
        }
        arrayList = this.myConstructors;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getConstructors must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<RefElement> getInTypeReferences() {
        HashSet<RefElement> hashSet;
        if (this.myInTypeReferences == null) {
            hashSet = EMPTY_SET;
            if (hashSet == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getInTypeReferences must not return null");
            return hashSet;
        }
        hashSet = this.myInTypeReferences;
        if (hashSet != null) return hashSet;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getInTypeReferences must not return null");
    }

    public void addTypeReference(RefJavaElement from) {
        if (from != null) {
            if (this.myInTypeReferences == null) {
                this.myInTypeReferences = new THashSet(1);
            }
            this.myInTypeReferences.add((Object)from);
            ((RefJavaElementImpl)from).addOutTypeRefernce(this);
            this.getRefManager().fireNodeMarkedReferenced(this, (RefElement)from, false, false, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<RefElement> getInstanceReferences() {
        HashSet<RefElement> hashSet;
        if (this.myInstanceReferences == null) {
            hashSet = EMPTY_SET;
            if (hashSet == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getInstanceReferences must not return null");
            return hashSet;
        }
        hashSet = this.myInstanceReferences;
        if (hashSet != null) return hashSet;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getInstanceReferences must not return null");
    }

    public void addInstanceReference(RefElement from) {
        if (this.myInstanceReferences == null) {
            this.myInstanceReferences = new THashSet(1);
        }
        this.myInstanceReferences.add((Object)from);
    }

    public RefMethod getDefaultConstructor() {
        return this.myDefaultConstructor;
    }

    private void addConstructor(RefMethod refConstructor) {
        if (this.myConstructors == null) {
            this.myConstructors = new ArrayList(1);
        }
        this.myConstructors.add(refConstructor);
    }

    public void addLibraryOverrideMethod(RefMethod refMethod) {
        if (this.myOverridingMethods == null) {
            this.myOverridingMethods = new ArrayList(2);
        }
        this.myOverridingMethods.add(refMethod);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<RefMethod> getLibraryMethods() {
        ArrayList<RefMethod> arrayList;
        if (this.myOverridingMethods == null) {
            arrayList = EMPTY_METHOD_LIST;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getLibraryMethods must not return null");
            return arrayList;
        }
        arrayList = this.myOverridingMethods;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getLibraryMethods must not return null");
    }

    public boolean isAnonymous() {
        return this.checkFlag(65536);
    }

    public boolean isInterface() {
        return this.checkFlag(131072);
    }

    @Override
    public boolean isSuspicious() {
        return (!this.isUtilityClass() || !this.getOutReferences().isEmpty()) && super.isSuspicious();
    }

    public boolean isUtilityClass() {
        return this.checkFlag(262144);
    }

    @Override
    public String getExternalName() {
        final String[] result = new String[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = RefClassImpl.this.getElement();
                RefElementImpl.LOG.assertTrue(psiClass != null);
                result[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiClass);
            }
        });
        return result[0];
    }

    @Nullable
    public static RefClass classFromExternalName(RefManager manager, String externalName) {
        return (RefClass)manager.getReference((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)manager.getProject()), (String)externalName));
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        for (RefClass subClass : this.getSubClasses()) {
            ((RefClassImpl)subClass).removeBase(this);
        }
        for (RefClass superClass : this.getBaseClasses()) {
            superClass.getSubClasses().remove(this);
        }
    }

    private void removeBase(RefClass superClass) {
        this.getBaseClasses().remove(superClass);
    }

    protected void methodRemoved(RefMethod method) {
        this.getConstructors().remove(method);
        this.getLibraryMethods().remove(method);
        if (this.getDefaultConstructor() == method) {
            this.setDefaultConstructor(null);
        }
    }

    public boolean isAbstract() {
        return this.checkFlag(524288);
    }

    public boolean isApplet() {
        return this.checkFlag(0x200000);
    }

    public boolean isServlet() {
        return this.checkFlag(0x400000);
    }

    public boolean isTestCase() {
        return this.checkFlag(0x800000);
    }

    public boolean isLocalClass() {
        return this.checkFlag(0x1000000);
    }

    @Override
    public boolean isReferenced() {
        if (super.isReferenced()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && this.getSubClasses().size() > 0;
    }

    @Override
    public boolean hasSuspiciousCallers() {
        if (super.hasSuspiciousCallers()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && this.getSubClasses().size() > 0;
    }

    public void addClassExporter(RefJavaElement exporter) {
        if (this.myClassExporters == null) {
            this.myClassExporters = new ArrayList(1);
        }
        if (this.myClassExporters.contains(exporter)) {
            return;
        }
        this.myClassExporters.add(exporter);
    }

    public List<RefJavaElement> getClassExporters() {
        return this.myClassExporters;
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536);
    }

    private void setInterface(boolean anInterface) {
        this.setFlag(anInterface, 131072);
    }

    private void setUtilityClass(boolean utilityClass) {
        this.setFlag(utilityClass, 262144);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288);
    }

    private void setApplet(boolean applet) {
        this.setFlag(applet, 0x200000);
    }

    private void setServlet(boolean servlet) {
        this.setFlag(servlet, 0x400000);
    }

    private void setTestCase(boolean testCase) {
        this.setFlag(testCase, 0x800000);
    }

    private void setIsLocal(boolean isLocal) {
        this.setFlag(isLocal, 0x1000000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefMethod refMethod;
        RefMethod defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor != null) {
            refMethod = defaultConstructor;
            if (refMethod == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getContainingEntry must not return null");
            return refMethod;
        }
        refMethod = super.getContainingEntry();
        if (refMethod != null) return refMethod;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefClassImpl.getContainingEntry must not return null");
    }
}

