/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameParameterValueInspection
extends GlobalJavaInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + SameParameterValueInspection.class.getName()));

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        ArrayList<ProblemDescriptor> problems = null;
        if (refEntity instanceof RefMethod) {
            RefParameter[] parameters;
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            for (RefParameter refParameter : parameters = refMethod.getParameters()) {
                String value = refParameter.getActualValueIfSame();
                if (value == null) continue;
                if (problems == null) {
                    problems = new ArrayList<ProblemDescriptor>(1);
                }
                String paramName = refParameter.getName();
                problems.add(manager.createProblemDescriptor((PsiElement)refParameter.getElement(), InspectionsBundle.message((String)"inspection.same.parameter.problem.descriptor", (Object[])new Object[]{"<code>" + paramName + "</code>", "<code>" + value + "</code>"}), (LocalQuickFix)new InlineParameterValueFix(paramName, value), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
            }
        }
        return problems == null ? null : problems.toArray(new CommonProblemDescriptor[problems.size()]);
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext globalContext, final ProblemDescriptionsProcessor processor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final RefMethod refMethod) {
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.same.parameter.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("SameParameterValue" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection.getShortName must not return null");
        }
        return "SameParameterValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        if (hint == null) {
            return null;
        }
        int spaceIdx = hint.indexOf(32);
        if (spaceIdx == -1 || spaceIdx >= hint.length() - 1) {
            return null;
        }
        String paramName = hint.substring(0, spaceIdx);
        String value = hint.substring(spaceIdx + 1);
        return new InlineParameterValueFix(paramName, value);
    }

    @Nullable
    public String getHint(QuickFix fix) {
        InlineParameterValueFix valueFix = (InlineParameterValueFix)fix;
        return valueFix.getParamName() + " " + valueFix.getValue();
    }

    public static class InlineParameterValueFix
    implements LocalQuickFix {
        private final String myValue;
        private final String myParameterName;

        public InlineParameterValueFix(String parameterName, String value) {
            this.myValue = value;
            this.myParameterName = parameterName;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.name", (Object[])new Object[]{this.myParameterName, this.myValue});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression defToInline;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix.applyFix must not be null");
            }
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            LOG.assertTrue(method != null);
            PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
            if (parameter == null) {
                PsiParameter[] parameters;
                for (PsiParameter psiParameter : parameters = method.getParameterList().getParameters()) {
                    if (!Comparing.strEqual((String)psiParameter.getName(), (String)this.myParameterName)) continue;
                    parameter = psiParameter;
                    break;
                }
            }
            if (parameter == null) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)parameter)) {
                return;
            }
            try {
                defToInline = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(this.myValue, (PsiElement)parameter);
            }
            catch (IncorrectOperationException e) {
                return;
            }
            InlineParameterValueFix.inlineSameParameterValue(method, parameter, defToInline);
        }

        public static void inlineSameParameterValue(final PsiMethod method, final PsiParameter parameter, final PsiExpression defToInline) {
            final Collection refsToInline = ReferencesSearch.search((PsiElement)parameter).findAll();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiExpression[] exprs = new PsiExpression[refsToInline.size()];
                        int idx = 0;
                        for (PsiReference reference : refsToInline) {
                            if (!(reference instanceof PsiJavaCodeReferenceElement)) continue;
                            exprs[idx++] = InlineUtil.inlineVariable((PsiVariable)parameter, defToInline, (PsiJavaCodeReferenceElement)reference);
                        }
                        for (PsiExpression expr : exprs) {
                            if (expr == null) continue;
                            InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                        }
                        InlineParameterValueFix.removeParameter(method, parameter);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            ApplicationManager.getApplication().runWriteAction(runnable);
        }

        public static void removeParameter(PsiMethod method, PsiParameter parameter) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
            int paramIdx = 0;
            String paramName = parameter.getName();
            for (PsiParameter param : parameters) {
                if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                    psiParameters.add(new ParameterInfoImpl(paramIdx, param.getName(), param.getType()));
                }
                ++paramIdx;
            }
            new ChangeSignatureProcessor(method.getProject(), method, false, null, method.getName(), method.getReturnType(), psiParameters.toArray(new ParameterInfoImpl[psiParameters.size()])).run();
        }

        public String getValue() {
            return this.myValue;
        }

        public String getParamName() {
            return this.myParameterName;
        }
    }
}

