/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean myInitialized;
    private final DebuggerSession myDebuggerSession;
    private final DebugProcessImpl myDebugProcess;
    private final SuspendContextImpl mySuspendContext;
    private final ThreadReferenceProxyImpl myThreadProxy;
    private StackFrameProxyImpl myFrameProxy;
    private SourcePosition mySourcePosition;
    private PsiElement myContextElement;

    private DebuggerContextImpl(DebuggerSession session, DebugProcessImpl debugProcess, SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy, SourcePosition position, PsiElement contextElement, boolean initialized) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        LOG.assertTrue(debugProcess == null ? frameProxy == null && threadProxy == null : true);
        this.myDebuggerSession = session;
        this.myThreadProxy = threadProxy;
        this.myFrameProxy = frameProxy;
        this.myDebugProcess = debugProcess;
        this.mySourcePosition = position;
        this.mySuspendContext = context;
        this.myContextElement = contextElement;
        this.myInitialized = initialized;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    public DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.myThreadProxy;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public Project getProject() {
        return this.myDebugProcess != null ? this.myDebugProcess.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        LOG.assertTrue(this.myInitialized);
        return this.myFrameProxy;
    }

    public SourcePosition getSourcePosition() {
        LOG.assertTrue(this.myInitialized);
        return this.mySourcePosition;
    }

    public PsiElement getContextElement() {
        LOG.assertTrue(this.myInitialized);
        if (this.myContextElement != null && !this.myContextElement.isValid()) {
            this.myContextElement = ContextUtil.getContextElement(this.mySourcePosition);
        }
        return this.myContextElement;
    }

    public EvaluationContextImpl createEvaluationContext(Value thisObject) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), thisObject);
    }

    public EvaluationContextImpl createEvaluationContext() {
        ObjectReference objectReference;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        StackFrameProxyImpl frameProxy = this.getFrameProxy();
        try {
            objectReference = frameProxy != null ? frameProxy.thisObject() : null;
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            objectReference = null;
        }
        return new EvaluationContextImpl(this.getSuspendContext(), frameProxy, objectReference);
    }

    public static DebuggerContextImpl createDebuggerContext(DebuggerSession session, SuspendContextImpl context, ThreadReferenceProxyImpl threadProxy, StackFrameProxyImpl frameProxy) {
        LOG.assertTrue(frameProxy == null || threadProxy == null || threadProxy == frameProxy.threadProxy());
        LOG.assertTrue(session == null || session.getProcess() != null);
        return new DebuggerContextImpl(session, session != null ? session.getProcess() : null, context, threadProxy, frameProxy, null, null, context == null);
    }

    public void initCaches() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        if (this.myFrameProxy == null && this.myThreadProxy != null) {
            try {
                this.myFrameProxy = this.myThreadProxy.frameCount() > 0 ? this.myThreadProxy.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.myFrameProxy != null) {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAndRunReadAction(new Runnable(){

                @Override
                public void run() {
                    if (DebuggerContextImpl.this.mySourcePosition == null) {
                        DebuggerContextImpl.this.mySourcePosition = ContextUtil.getSourcePosition((StackFrameContext)DebuggerContextImpl.this);
                    }
                    DebuggerContextImpl.this.myContextElement = ContextUtil.getContextElement(DebuggerContextImpl.this.mySourcePosition);
                }
            });
        }
    }

    public void setPositionCache(SourcePosition position) {
        LOG.assertTrue(!this.myInitialized, (Object)"Debugger context is initialized. Cannot change caches");
        this.mySourcePosition = position;
    }

    public boolean isInitialised() {
        return this.myInitialized;
    }

    public boolean isEvaluationPossible() {
        return this.getDebugProcess().getSuspendManager().getPausedContext() != null;
    }
}

