/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class DefaultJavaProgramRunner
extends JavaPatchableProgramRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/DefaultJavaProgramRunner.canRun must not be null");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/impl/DefaultJavaProgramRunner.canRun must not be null");
        }
        return executorId.equals(DefaultRunExecutor.EXECUTOR_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RemoteConfiguration);
    }

    public JDOMExternalizable createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return null;
    }

    public SettingsEditor<JDOMExternalizable> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, boolean beforeExecution) throws ExecutionException {
        DefaultJavaProgramRunner.runCustomPatchers((JavaParameters)javaParameters, (RunnerSettings)settings, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtension(DefaultRunExecutor.class)));
    }

    public void checkConfiguration(RunnerSettings settings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    public AnAction[] createActions(ExecutionResult executionResult) {
        return AnAction.EMPTY_ARRAY;
    }

    protected RunContentDescriptor doExecute(Project project, Executor executor, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        AnAction[] actions;
        ExecutionResult executionResult;
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean shouldAddDefaultActions = true;
        if (state instanceof JavaCommandLine) {
            JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
            this.patch(parameters, state.getRunnerSettings(), true);
            ProcessProxy proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
            executionResult = state.execute(executor, (ProgramRunner)this);
            if (proxy != null && executionResult != null) {
                proxy.attach(executionResult.getProcessHandler());
            }
            if (state instanceof JavaCommandLineState && !((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                shouldAddDefaultActions = false;
            }
        } else {
            executionResult = state.execute(executor, (ProgramRunner)this);
        }
        if (executionResult == null) {
            return null;
        }
        this.onProcessStarted(env.getRunnerSettings(), executionResult);
        RunContentBuilder contentBuilder = new RunContentBuilder(project, (ProgramRunner)this, executor);
        contentBuilder.setExecutionResult(executionResult);
        contentBuilder.setEnvironment(env);
        if (shouldAddDefaultActions) {
            DefaultJavaProgramRunner.addDefaultActions(contentBuilder);
        }
        RunContentDescriptor runContent = contentBuilder.showRunContent(contentToReuse);
        for (AnAction action : actions = this.createActions(contentBuilder.getExecutionResult())) {
            contentBuilder.addAction(action);
        }
        return runContent;
    }

    protected static void addDefaultActions(RunContentBuilder contentBuilder) {
        ExecutionResult executionResult = contentBuilder.getExecutionResult();
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        final JComponent consoleComponent = executionConsole != null ? executionConsole.getComponent() : null;
        final ControlBreakAction controlBreakAction = new ControlBreakAction(contentBuilder.getProcessHandler());
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            final ProcessHandler processHandler = executionResult.getProcessHandler();
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    processHandler.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }
            });
        }
        contentBuilder.addAction(controlBreakAction);
        contentBuilder.addAction(new SoftExitAction(contentBuilder.getProcessHandler()));
    }

    @NotNull
    public String getRunnerId() {
        if ("Run" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/DefaultJavaProgramRunner.getRunnerId must not return null");
        }
        return "Run";
    }

    protected static class SoftExitAction
    extends LauncherBasedAction {
        public SoftExitAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/exit.png"), processHandler);
        }

        public void actionPerformed(AnActionEvent e) {
            ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler).sendStop();
        }
    }

    protected static class ControlBreakAction
    extends LauncherBasedAction {
        public ControlBreakAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/dump.png"), processHandler);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        public void actionPerformed(AnActionEvent e) {
            ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler).sendBreak();
        }
    }

    private static abstract class LauncherBasedAction
    extends AnAction {
        protected final ProcessHandler myProcessHandler;

        protected LauncherBasedAction(String text, String description, Icon icon, ProcessHandler processHandler) {
            super(text, description, icon);
            this.myProcessHandler = processHandler;
        }

        public void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            if (ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler) == null) {
                presentation.setVisible(false);
                presentation.setEnabled(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(!this.myProcessHandler.isProcessTerminated());
        }
    }
}

