/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayoutUiImpl
implements Disposable,
RunnerLayoutUi,
LayoutStateDefaults,
LayoutViewOptions {
    private final RunnerLayout myLayout;
    private final JPanel myContentPanel;
    private final RunnerContentUi myContentUI;
    private final ContentManager myViewsContentManager;
    public static final Key<String> CONTENT_TYPE = Key.create((String)"ContentType");

    public RunnerLayoutUiImpl(Project project, Disposable parent, String runnerType, String runnerTitle, String sessionName) {
        this.myLayout = RunnerLayoutSettings.getInstance().getLayout(runnerType);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myContentUI = new RunnerContentUi(project, this, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project), this.myLayout, runnerTitle + " - " + sessionName);
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myViewsContentManager = RunnerLayoutUiImpl.getContentFactory().createContentManager(this.myContentUI.getContentUI(), false, project);
        Disposer.register((Disposable)this, (Disposable)this.myViewsContentManager);
        this.myContentPanel.add((Component)this.myViewsContentManager.getComponent(), "Center");
    }

    @NotNull
    public LayoutViewOptions setTopToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setTopToolbar must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setTopToolbar must not be null");
        }
        this.myContentUI.setTopActions(actions, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setTopToolbar must not return null");
        }
        return runnerLayoutUiImpl;
    }

    public LayoutStateDefaults initTabDefaults(int id, String text, Icon icon) {
        this.getLayout().setDefault(id, text, icon);
        return this;
    }

    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.initFocusContent must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.initFocusContent must not be null");
        }
        return this.initFocusContent(id, condition, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
    }

    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.initFocusContent must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.initFocusContent must not be null");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.initFocusContent must not be null");
        }
        this.getLayout().setDefaultToFocus(id, condition, policy);
        return this;
    }

    @NotNull
    public Content addContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addContent must not be null");
        }
        Content content2 = this.addContent(content, false, -1, PlaceInGrid.center, false);
        if (content2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addContent must not return null");
        }
        return content2;
    }

    @NotNull
    public Content addContent(@NotNull Content content, int defaultTabId, PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addContent must not be null");
        }
        Content content2 = this.addContent(content, true, defaultTabId, defaultPlace, defaultIsMinimized);
        if (content2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addContent must not return null");
        }
        return content2;
    }

    public Content addContent(Content content, boolean applyDefaults, int defaultTabId, PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        String id = (String)content.getUserData(CONTENT_TYPE);
        assert (id != null) : "Content id is missing, use RunnerLayoutUi to create content instances";
        if (applyDefaults) {
            this.getLayout().setDefault(id, defaultTabId, defaultPlace, defaultIsMinimized);
        }
        this.getContentManager().addContent(content);
        return content;
    }

    @NotNull
    public Content createContent(@NotNull String id, @NotNull JComponent component, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent focusable) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        Content content = this.createContent(id, (ComponentWithActions)new ComponentWithActions.Impl(component), displayName, icon, focusable);
        if (content == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not return null");
        }
        return content;
    }

    @NotNull
    public Content createContent(@NotNull String contentId, @NotNull ComponentWithActions withActions, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent toFocus) {
        if (contentId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        if (withActions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not be null");
        }
        Content content = RunnerLayoutUiImpl.getContentFactory().createContent(withActions.getComponent(), displayName, false);
        content.putUserData(CONTENT_TYPE, (Object)contentId);
        content.putUserData(ViewImpl.ID, (Object)contentId);
        content.setIcon(icon);
        if (toFocus != null) {
            content.setPreferredFocusableComponent(toFocus);
        }
        if (!withActions.isContentBuiltIn()) {
            content.setSearchComponent(withActions.getSearchComponent());
            content.setActions(withActions.getToolbarActions(), withActions.getToolbarPlace(), withActions.getToolbarContextComponent());
        }
        Content content2 = content;
        if (content2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.createContent must not return null");
        }
        return content2;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.getComponent must not return null");
        }
        return jPanel;
    }

    private static ContentFactory getContentFactory() {
        return ContentFactory.SERVICE.getInstance();
    }

    public RunnerLayout getLayout() {
        return this.myLayout;
    }

    public void updateActionsNow() {
        this.myContentUI.updateActionsImmediately();
    }

    public void dispose() {
    }

    @NotNull
    public ContentManager getContentManager() {
        ContentManager contentManager = this.myViewsContentManager;
        if (contentManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.getContentManager must not return null");
        }
        return contentManager;
    }

    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced) {
        return this.selectAndFocus(content, requestFocus, forced, false);
    }

    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced, boolean implicit) {
        if (content == null) {
            return new ActionCallback.Rejected();
        }
        return this.getContentManager().setSelectedContent(content, requestFocus || this.shouldRequestFocus(), forced, implicit);
    }

    private boolean shouldRequestFocus() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.isDescendingFrom(focused, this.getContentManager().getComponent());
    }

    public boolean removeContent(Content content, boolean dispose) {
        if (content == null) {
            return false;
        }
        return this.getContentManager().removeContent(content, dispose);
    }

    public boolean isToFocus(Content content, String condition) {
        String id = (String)content.getUserData(ViewImpl.ID);
        return this.getLayout().isToFocus(id, condition);
    }

    public LayoutViewOptions setToFocus(@Nullable Content content, String condition) {
        this.getLayout().setToFocus(content != null ? (String)content.getUserData(ViewImpl.ID) : null, condition);
        return this;
    }

    public void attractBy(@NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.attractBy must not be null");
        }
        this.myContentUI.attractByCondition(condition, true);
    }

    public void clearAttractionBy(String condition) {
        this.myContentUI.clearAttractionByCondition(condition, true);
    }

    public void removeContent(String id, boolean dispose) {
        Content content = this.findContent(id);
        if (content != null) {
            this.getContentManager().removeContent(content, dispose);
        }
    }

    public AnAction getLayoutActions() {
        return this.myContentUI.getLayoutActions();
    }

    public AnAction[] getLayoutActionsList() {
        ActionGroup group = (ActionGroup)this.getLayoutActions();
        return group.getChildren(null);
    }

    public LayoutViewOptions setLeftToolbar(@NotNull ActionGroup leftToolbar, @NotNull String place) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setLeftToolbar must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setLeftToolbar must not be null");
        }
        this.myContentUI.setLeftToolbar(leftToolbar, place);
        return this;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.findContent must not be null");
        }
        return this.myContentUI.findContent(key);
    }

    public RunnerLayoutUi addListener(final @NotNull ContentManagerListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addListener must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.addListener must not be null");
        }
        final ContentManager mgr = this.getContentManager();
        mgr.addContentManagerListener(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                mgr.removeContentManagerListener(listener);
            }
        });
        return this;
    }

    public void removeListener(@NotNull ContentManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.removeListener must not be null");
        }
        this.getContentManager().removeContentManagerListener(listener);
    }

    public void setBouncing(@NotNull Content content, boolean activate) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setBouncing must not be null");
        }
        this.myContentUI.processBounce(content, activate);
    }

    public boolean isDisposed() {
        return this.getContentManager().isDisposed();
    }

    @NotNull
    public LayoutViewOptions setMinimizeActionEnabled(boolean enabled) {
        this.myContentUI.setMinimizeActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setMinimizeActionEnabled must not return null");
        }
        return runnerLayoutUiImpl;
    }

    public LayoutViewOptions setToDisposeRemoveContent(boolean toDispose) {
        this.myContentUI.setToDisposeRemovedContent(toDispose);
        return this;
    }

    @NotNull
    public LayoutViewOptions setMoveToGridActionEnabled(boolean enabled) {
        this.myContentUI.setMovetoGridActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setMoveToGridActionEnabled must not return null");
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setAttractionPolicy(@NotNull String contentId, LayoutAttractionPolicy policy) {
        if (contentId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setAttractionPolicy must not be null");
        }
        this.myContentUI.setPolicy(contentId, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setAttractionPolicy must not return null");
        }
        return runnerLayoutUiImpl;
    }

    public LayoutViewOptions setConditionAttractionPolicy(@NotNull String condition, LayoutAttractionPolicy policy) {
        if (condition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.setConditionAttractionPolicy must not be null");
        }
        this.myContentUI.setConditionPolicy(condition, policy);
        return this;
    }

    @NotNull
    public LayoutStateDefaults getDefaults() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.getDefaults must not return null");
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions getOptions() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl.getOptions must not return null");
        }
        return runnerLayoutUiImpl;
    }

    public LayoutViewOptions setAdditionalFocusActions(ActionGroup group) {
        this.myContentUI.setAdditionalFocusActions(group);
        return this;
    }

    public Content[] getContents() {
        Content[] contents = new Content[this.getContentManager().getContentCount()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = this.getContentManager().getContent(i);
        }
        return contents;
    }
}

