/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries.versions;

import com.intellij.facet.impl.ui.libraries.versions.LibraryVersionInfo;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VersionsComponent {
    private JPanel myMainPanel;
    private static String UNKNOWN_RI_NAME = "Unknown";
    @NotNull
    private final Module myModule;
    private FacetLibrariesValidator myValidator;
    private ButtonGroup myButtonGroup;
    private Map<String, Pair<JRadioButton, JComboBox>> myButtons;
    private LibraryVersionInfo myCurrentVersion;

    public VersionsComponent(@NotNull Module module, FacetLibrariesValidator validator) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.<init> must not be null");
        }
        this.myButtonGroup = new ButtonGroup();
        this.myButtons = new HashMap();
        this.myCurrentVersion = null;
        this.myModule = module;
        this.myValidator = validator;
    }

    public JPanel getJComponent() {
        if (this.myMainPanel == null) {
            this.init();
        }
        return this.myMainPanel;
    }

    @Nullable
    public LibraryVersionInfo getCurrentLibraryVersionInfo() {
        return this.myCurrentVersion;
    }

    private void init() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        Set<String> referenceImplementations = this.getRIs();
        if (referenceImplementations.size() == 1) {
            String ri = referenceImplementations.iterator().next();
            this.addSingletonReferenceImplementationUI(ri);
        } else {
            Pair<JRadioButton, JComboBox> currentPair;
            for (String ri : referenceImplementations) {
                this.addMultipleReferenceImplementationUI(ri);
                if (this.myCurrentVersion != null) continue;
                this.myCurrentVersion = this.getCurrentVersion(ri);
            }
            if (this.myCurrentVersion != null && (currentPair = this.myButtons.get(this.myCurrentVersion.getRI())) != null) {
                ((JRadioButton)currentPair.first).setSelected(true);
                ((JComboBox)currentPair.second).setSelectedItem(this.myCurrentVersion);
                for (Pair<JRadioButton, JComboBox> buttonsPair : this.myButtons.values()) {
                    ((JComboBox)buttonsPair.second).setEnabled(buttonsPair == currentPair);
                }
            }
        }
    }

    @Nullable
    protected String getFacetDetectionClass(@NotNull String currentRI) {
        if (currentRI == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.getFacetDetectionClass must not be null");
        }
        return null;
    }

    @NotNull
    protected abstract Map<LibraryVersionInfo, List<LibraryInfo>> getLibraries();

    @Nullable
    private LibraryVersionInfo getCurrentVersion(@NotNull String currentRI) {
        String version;
        if (currentRI == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.getCurrentVersion must not be null");
        }
        String detectionClass = this.getFacetDetectionClass(currentRI);
        if (detectionClass != null && (version = JarVersionDetectionUtil.detectJarVersion((String)detectionClass, (Module)this.myModule)) != null) {
            LibraryVersionInfo approximatedVersion = null;
            for (LibraryVersionInfo info : this.getLibraries().keySet()) {
                if (version.equals(info.getVersion())) {
                    return info;
                }
                if (!version.contains(info.getVersion())) continue;
                approximatedVersion = info;
            }
            return approximatedVersion;
        }
        return null;
    }

    private List<LibraryVersionInfo> getSupportedVersions(@NotNull String ri) {
        if (ri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.getSupportedVersions must not be null");
        }
        ArrayList<LibraryVersionInfo> versions = new ArrayList<LibraryVersionInfo>();
        for (Map.Entry<LibraryVersionInfo, List<LibraryInfo>> entry : this.getLibraries().entrySet()) {
            if (!ri.equals(entry.getKey().getRI())) continue;
            versions.add(entry.getKey());
        }
        return versions;
    }

    private void addSingletonReferenceImplementationUI(@NotNull String ri) {
        if (ri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.addSingletonReferenceImplementationUI must not be null");
        }
        JComboBox comboBox = this.createComboBox(ri);
        this.addToPanel(new JLabel(ri), comboBox);
        LibraryVersionInfo version = this.getCurrentVersion(ri);
        if (version != null) {
            comboBox.setSelectedItem(version);
        }
    }

    private void addMultipleReferenceImplementationUI(@NotNull String ri) {
        if (ri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.addMultipleReferenceImplementationUI must not be null");
        }
        JRadioButton radioButton = this.createRadioButton(ri);
        JComboBox comboBox = this.createComboBox(ri);
        comboBox.setEnabled(false);
        this.addToPanel(radioButton, comboBox);
        this.myButtons.put(ri, (Pair<JRadioButton, JComboBox>)new Pair((Object)radioButton, (Object)comboBox));
        this.myButtonGroup.add(radioButton);
    }

    private void addToPanel(@NotNull JComponent first, @NotNull JComponent second) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.addToPanel must not be null");
        }
        if (second == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.addToPanel must not be null");
        }
        this.myMainPanel.add((Component)first, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.myMainPanel.add((Component)second, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 22, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private JRadioButton createRadioButton(final String ri) {
        final JRadioButton radioButton = new JRadioButton(ri);
        radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Pair pair : VersionsComponent.this.myButtons.values()) {
                    if (((JRadioButton)pair.getFirst()).equals(radioButton)) {
                        JComboBox comboBox = (JComboBox)pair.second;
                        comboBox.setEnabled(true);
                        LibraryVersionInfo currentVersion = VersionsComponent.this.getCurrentVersion(ri);
                        if (currentVersion != null) {
                            comboBox.setSelectedItem(currentVersion);
                            continue;
                        }
                        if (comboBox.getSelectedIndex() < 0) {
                            comboBox.setSelectedItem(VersionsComponent.getAppropriateVersion(VersionsComponent.this.getSupportedVersions(ri)));
                            continue;
                        }
                        VersionsComponent.this.updateCurrentVersion(comboBox);
                        continue;
                    }
                    ((JComboBox)pair.second).setEnabled(false);
                }
            }
        });
        return radioButton;
    }

    private JComboBox createComboBox(String ri) {
        final JComboBox comboBox = new JComboBox();
        List<LibraryVersionInfo> versions = this.getSupportedVersions(ri);
        comboBox.setModel(new CollectionComboBoxModel(versions, null));
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionsComponent.this.updateCurrentVersion(comboBox);
            }
        });
        return comboBox;
    }

    private void updateCurrentVersion(JComboBox comboBox) {
        LibraryVersionInfo versionInfo = VersionsComponent.getSelectedVersion(comboBox);
        if (versionInfo != null) {
            this.myCurrentVersion = versionInfo;
            this.myValidator.setDescription(this.getFacetLibrariesValidatorDescription(versionInfo));
            this.myValidator.setRequiredLibraries(this.getRequiredLibraries(versionInfo));
        }
    }

    protected FacetLibrariesValidatorDescription getFacetLibrariesValidatorDescription(LibraryVersionInfo versionInfo) {
        return new FacetLibrariesValidatorDescription(versionInfo.getVersion()){

            @NonNls
            public String getDefaultLibraryName() {
                if (VersionsComponent.this.myCurrentVersion != null) {
                    String ri = VersionsComponent.this.myCurrentVersion.getRI();
                    String version = VersionsComponent.this.myCurrentVersion.getVersion();
                    return StringUtil.isEmptyOrSpaces((String)ri) ? version : ri + "." + version;
                }
                return super.getDefaultLibraryName();
            }
        };
    }

    @Nullable
    private static LibraryVersionInfo getAppropriateVersion(List<LibraryVersionInfo> versions) {
        return versions.size() > 0 ? versions.get(0) : null;
    }

    private LibraryInfo[] getRequiredLibraries(LibraryVersionInfo versionInfo) {
        List<LibraryInfo> libraryInfos = this.getLibraries().get(versionInfo);
        return libraryInfos.toArray(new LibraryInfo[libraryInfos.size()]);
    }

    @Nullable
    private static LibraryVersionInfo getSelectedVersion(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.getSelectedVersion must not be null");
        }
        Object version = comboBox.getModel().getSelectedItem();
        return version instanceof LibraryVersionInfo ? (LibraryVersionInfo)version : null;
    }

    public FacetLibrariesValidator getValidator() {
        return this.myValidator;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/versions/VersionsComponent.getModule must not return null");
        }
        return module;
    }

    public Set<String> getRIs() {
        HashSet ris = new HashSet();
        for (LibraryVersionInfo info : this.getLibraries().keySet()) {
            String ri = info.getRI();
            if (!StringUtil.isEmptyOrSpaces((String)ri)) {
                ris.add(ri);
                continue;
            }
            ris.add(UNKNOWN_RI_NAME);
        }
        return ris;
    }
}

