/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TrigramIndex
extends ScalarIndexExtension<Integer> {
    public static final boolean ENABLED = "true".equals(System.getProperty("idea.internal.trigramindex.enabled"));
    public static final ID<Integer, Void> INDEX_ID = ID.create((String)"Trigram.Index");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            return !file.getFileType().isBinary();
        }
    };
    private static final FileBasedIndex.InputFilter NO_FILES = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            return false;
        }
    };

    @Override
    public ID<Integer, Void> getName() {
        return INDEX_ID;
    }

    @Override
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return new DataIndexer<Integer, Void, FileContent>(){

            @Override
            @NotNull
            public Map<Integer, Void> map(FileContent inputData) {
                THashMap result = new THashMap();
                TIntHashSet built = TrigramBuilder.buildTrigram((CharSequence)inputData.getContentAsText());
                built.forEach(new TIntProcedure((Map)result){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public boolean execute(int value) {
                        this.val$result.put(value, null);
                        return true;
                    }
                });
                THashMap tHashMap = result;
                if (tHashMap == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/find/ngrams/TrigramIndex$3.map must not return null");
                }
                return tHashMap;
            }
        };
    }

    @Override
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return new EnumeratorIntegerDescriptor();
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        if (ENABLED) {
            return INPUT_FILTER;
        }
        return NO_FILES;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return ENABLED ? 2 : 1;
    }
}

