/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.ModifyKeywordDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.ui.DialogButtonGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.TabbedPaneWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CustomFileTypeEditor
extends SettingsEditor<AbstractFileType> {
    private final JTextField myFileTypeName = new JTextField(26);
    private final JTextField myFileTypeDescr = new JTextField(26);
    private final JCheckBox myIgnoreCase = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.ignore.case", (Object[])new Object[0]));
    private final JCheckBox mySupportBraces = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.braces", (Object[])new Object[0]));
    private final JCheckBox mySupportBrackets = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.brackets", (Object[])new Object[0]));
    private final JCheckBox mySupportParens = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.paired.parens", (Object[])new Object[0]));
    private final JCheckBox mySupportEscapes = new JCheckBox(IdeBundle.message((String)"checkbox.customfiletype.support.string.escapes", (Object[])new Object[0]));
    private final JTextField myLineComment = new JTextField(20);
    private final JTextField myBlockCommentStart = new JTextField(20);
    private final JTextField myBlockCommentEnd = new JTextField(20);
    private final JTextField myHexPrefix = new JTextField(20);
    private final JTextField myNumPostfixes = new JTextField(20);
    private final JList[] myKeywordsLists = new JList[]{new JList(), new JList(), new JList(), new JList()};
    private final DefaultListModel[] myKeywordModels = new DefaultListModel[]{new DefaultListModel(), new DefaultListModel(), new DefaultListModel(), new DefaultListModel()};
    private final JButton[] myAddKeywordButtons = new JButton[4];
    private final JButton[] myRemoveKeywordButtons = new JButton[4];

    public void resetEditorFrom(AbstractFileType fileType) {
        this.myFileTypeName.setText(fileType.getName());
        this.myFileTypeDescr.setText(fileType.getDescription());
        SyntaxTable table = fileType.getSyntaxTable();
        if (table != null) {
            this.myLineComment.setText(table.getLineComment());
            this.myBlockCommentEnd.setText(table.getEndComment());
            this.myBlockCommentStart.setText(table.getStartComment());
            this.myHexPrefix.setText(table.getHexPrefix());
            this.myNumPostfixes.setText(table.getNumPostfixChars());
            this.myIgnoreCase.setSelected(table.isIgnoreCase());
            this.mySupportBraces.setSelected(table.isHasBraces());
            this.mySupportBrackets.setSelected(table.isHasBrackets());
            this.mySupportParens.setSelected(table.isHasParens());
            this.mySupportEscapes.setSelected(table.isHasStringEscapes());
            Iterator<String> i = table.getKeywords1().iterator();
            while (i.hasNext()) {
                this.myKeywordModels[0].addElement(i.next());
            }
            i = table.getKeywords2().iterator();
            while (i.hasNext()) {
                this.myKeywordModels[1].addElement(i.next());
            }
            i = table.getKeywords3().iterator();
            while (i.hasNext()) {
                this.myKeywordModels[2].addElement(i.next());
            }
            i = table.getKeywords4().iterator();
            while (i.hasNext()) {
                this.myKeywordModels[3].addElement(i.next());
            }
        }
    }

    public void applyEditorTo(AbstractFileType type) throws ConfigurationException {
        if (this.myFileTypeName.getText().trim().length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"error.name.cannot.be.empty", (Object[])new Object[0]), CommonBundle.getErrorTitle());
        }
        if (this.myFileTypeDescr.getText().trim().length() == 0) {
            this.myFileTypeDescr.setText(this.myFileTypeName.getText());
        }
        type.setName(this.myFileTypeName.getText());
        type.setDescription(this.myFileTypeDescr.getText());
        type.setSyntaxTable(this.getSyntaxTable());
    }

    public JComponent createEditor() {
        JComponent panel = this.createCenterPanel();
        for (int i = 0; i < this.myKeywordsLists.length; ++i) {
            this.myKeywordsLists[i].setModel(this.myKeywordModels[i]);
        }
        return panel;
    }

    public void disposeEditor() {
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel fileTypePanel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        JPanel info = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 2;
        info.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.name", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        info.add(this.myFileTypeName);
        gc.gridx = 0;
        gc.gridy = 2;
        info.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.description", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        info.add((Component)this.myFileTypeDescr, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        _panel0.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        _panel0.add((Component)info, "West");
        fileTypePanel.add((Component)_panel0, "North");
        JPanel panel1 = new JPanel();
        panel1.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.customfiletype.syntax.highlighting", (Object[])new Object[0])));
        JPanel highlighterPanel = panel1;
        highlighterPanel.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel();
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.customfiletype.options", (Object[])new Object[0])));
        JPanel commentsAndNumbersPanel = panel2;
        commentsAndNumbersPanel.setLayout(new GridBagLayout());
        JPanel _panel1 = new JPanel(new BorderLayout());
        gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.line.comment", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        commentsAndNumbersPanel.add((Component)this.myLineComment, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.start", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        commentsAndNumbersPanel.add((Component)this.myBlockCommentStart, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.block.comment.end", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        commentsAndNumbersPanel.add((Component)this.myBlockCommentEnd, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.hex.prefix", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        commentsAndNumbersPanel.add((Component)this.myHexPrefix, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)new JLabel(IdeBundle.message((String)"editbox.customfiletype.number.postfixes", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        commentsAndNumbersPanel.add((Component)this.myNumPostfixes, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)this.mySupportBraces, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)this.mySupportBrackets, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)this.mySupportParens, gc);
        gc.gridx = 0;
        ++gc.gridy;
        commentsAndNumbersPanel.add((Component)this.mySupportEscapes, gc);
        _panel1.add((Component)commentsAndNumbersPanel, "West");
        highlighterPanel.add((Component)_panel1, "North");
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper((Disposable)this);
        tabbedPaneWrapper.addTab("1", this.createKeywordsPanel(0));
        tabbedPaneWrapper.addTab("2", this.createKeywordsPanel(1));
        tabbedPaneWrapper.addTab("3", this.createKeywordsPanel(2));
        tabbedPaneWrapper.addTab("4", this.createKeywordsPanel(3));
        highlighterPanel.add((Component)tabbedPaneWrapper.getComponent(), "Center");
        highlighterPanel.add((Component)this.myIgnoreCase, "South");
        fileTypePanel.add((Component)highlighterPanel, "Center");
        panel.add(fileTypePanel);
        for (int i = 0; i < this.myKeywordsLists.length; ++i) {
            final int idx = i;
            this.myKeywordsLists[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CustomFileTypeEditor.this.edit(idx);
                    }
                }
            });
        }
        return panel;
    }

    private JPanel createKeywordsPanel(final int index) {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"listbox.customfiletype.keywords", (Object[])new Object[0])));
        JPanel keywordsPanel = panel;
        keywordsPanel.setLayout(new BorderLayout());
        keywordsPanel.add((Component)new JScrollPane(this.myKeywordsLists[index]), "Center");
        DialogButtonGroup buttonGroup = new DialogButtonGroup();
        buttonGroup.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        this.myAddKeywordButtons[index] = new JButton(IdeBundle.message((String)"button.add", (Object[])new Object[0]));
        this.myAddKeywordButtons[index].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyKeywordDialog dialog = new ModifyKeywordDialog(CustomFileTypeEditor.this.myAddKeywordButtons[index], "");
                dialog.show();
                if (dialog.isOK()) {
                    String keywordName = dialog.getKeywordName();
                    if (!CustomFileTypeEditor.this.myKeywordModels[index].contains(keywordName)) {
                        CustomFileTypeEditor.this.myKeywordModels[index].addElement(keywordName);
                    }
                }
            }
        });
        buttonGroup.addButton(this.myAddKeywordButtons[index]);
        this.myRemoveKeywordButtons[index] = new JButton(IdeBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myRemoveKeywordButtons[index].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.removeSelectedItems((JList)CustomFileTypeEditor.this.myKeywordsLists[index]);
            }
        });
        buttonGroup.addButton(this.myRemoveKeywordButtons[index]);
        keywordsPanel.add((Component)buttonGroup, "East");
        return keywordsPanel;
    }

    private void edit(int index) {
        if (this.myKeywordsLists[index].getSelectedIndex() == -1) {
            return;
        }
        ModifyKeywordDialog dialog = new ModifyKeywordDialog(this.myKeywordsLists[index], (String)this.myKeywordsLists[index].getSelectedValue());
        dialog.show();
        if (dialog.isOK()) {
            this.myKeywordModels[index].setElementAt(dialog.getKeywordName(), this.myKeywordsLists[index].getSelectedIndex());
        }
    }

    public SyntaxTable getSyntaxTable() {
        int i;
        SyntaxTable syntaxTable = new SyntaxTable();
        syntaxTable.setLineComment(this.myLineComment.getText());
        syntaxTable.setStartComment(this.myBlockCommentStart.getText());
        syntaxTable.setEndComment(this.myBlockCommentEnd.getText());
        syntaxTable.setHexPrefix(this.myHexPrefix.getText());
        syntaxTable.setNumPostfixChars(this.myNumPostfixes.getText());
        boolean ignoreCase = this.myIgnoreCase.isSelected();
        syntaxTable.setIgnoreCase(ignoreCase);
        syntaxTable.setHasBraces(this.mySupportBraces.isSelected());
        syntaxTable.setHasBrackets(this.mySupportBrackets.isSelected());
        syntaxTable.setHasParens(this.mySupportParens.isSelected());
        syntaxTable.setHasStringEscapes(this.mySupportEscapes.isSelected());
        for (i = 0; i < this.myKeywordModels[0].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword1(((String)this.myKeywordModels[0].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword1((String)this.myKeywordModels[0].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[1].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword2(((String)this.myKeywordModels[1].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword2((String)this.myKeywordModels[1].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[2].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword3(((String)this.myKeywordModels[2].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword3((String)this.myKeywordModels[2].getElementAt(i));
        }
        for (i = 0; i < this.myKeywordModels[3].size(); ++i) {
            if (ignoreCase) {
                syntaxTable.addKeyword4(((String)this.myKeywordModels[3].getElementAt(i)).toLowerCase());
                continue;
            }
            syntaxTable.addKeyword4((String)this.myKeywordModels[3].getElementAt(i));
        }
        return syntaxTable;
    }
}

