/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class FileDirRelativeToProjectRootMacro
extends Macro {
    @Override
    public String getName() {
        return "FileDirRelativeToProjectRoot";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.dir.relative.to.root", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        if (!file.isDirectory() && (file = file.getParent()) == null) {
            return null;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            return null;
        }
        return FileUtil.getRelativePath((File)FileDirRelativeToProjectRootMacro.getIOFile(contentRoot), (File)FileDirRelativeToProjectRootMacro.getIOFile(file));
    }
}

