/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortuct;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.Converter01;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class KeymapImpl
implements Keymap,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.keymap.KeymapImpl");
    @NonNls
    private static final String KEY_MAP = "keymap";
    @NonNls
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    @NonNls
    private static final String KEYBOARD_GESTURE_SHORTCUT = "keyboard-gesture-shortcut";
    @NonNls
    private static final String KEYBOARD_GESTURE_KEY = "keystroke";
    @NonNls
    private static final String KEYBOARD_GESTURE_MODIFIER = "modifier";
    @NonNls
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    @NonNls
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    @NonNls
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    @NonNls
    private static final String ACTION = "action";
    @NonNls
    private static final String VERSION_ATTRIBUTE = "version";
    @NonNls
    private static final String PARENT_ATTRIBUTE = "parent";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    @NonNls
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String BUTTON1 = "button1";
    @NonNls
    private static final String BUTTON2 = "button2";
    @NonNls
    private static final String BUTTON3 = "button3";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    @NonNls
    private static final String VIRTUAL_KEY_PREFIX = "VK_";
    @NonNls
    private static final String EDITOR_ACTION_PREFIX = "Editor";
    private String myName;
    private KeymapImpl myParent;
    private boolean myCanModify = true;
    private final Map<String, List<Shortcut>> myActionId2ListOfShortcuts = new THashMap();
    private Map<KeyStroke, List<String>> myKeystroke2ListOfIds = null;
    private Map<KeyboardModifierGestureShortuct, List<String>> myGesture2ListOfIds = null;
    private Map<MouseShortcut, List<String>> myMouseShortcut2ListOfIds = null;
    private static final Map<Integer, String> ourNamesForKeycodes;
    private static final Shortcut[] ourEmptyShortcutsArray;
    private final List<Keymap.Listener> myListeners = new ArrayList<Keymap.Listener>();
    private KeymapManagerEx myKeymapManager;
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.getName();
    }

    public void setName(String name) {
        this.myName = name;
    }

    public KeymapImpl deriveKeymap() {
        if (!this.canModify()) {
            KeymapImpl newKeymap = new KeymapImpl();
            newKeymap.myParent = this;
            newKeymap.myName = null;
            newKeymap.myCanModify = this.canModify();
            return newKeymap;
        }
        return this.copy(false);
    }

    public KeymapImpl copy(boolean copyExternalInfo) {
        KeymapImpl newKeymap = new KeymapImpl();
        newKeymap.myParent = this.myParent;
        newKeymap.myName = this.myName;
        newKeymap.myCanModify = this.canModify();
        newKeymap.myKeystroke2ListOfIds = null;
        newKeymap.myMouseShortcut2ListOfIds = null;
        for (Map.Entry<String, List<Shortcut>> entry : this.myActionId2ListOfShortcuts.entrySet()) {
            List<Shortcut> list = entry.getValue();
            String key = entry.getKey();
            newKeymap.myActionId2ListOfShortcuts.put(key, new ArrayList<Shortcut>(list));
        }
        if (copyExternalInfo) {
            newKeymap.myExternalInfo.copy(this.myExternalInfo);
        }
        return newKeymap;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Keymap)) {
            return false;
        }
        KeymapImpl secondKeymap = (KeymapImpl)object;
        if (!Comparing.equal((String)this.myName, (String)secondKeymap.myName)) {
            return false;
        }
        if (this.myCanModify != secondKeymap.myCanModify) {
            return false;
        }
        if (!Comparing.equal((Object)this.myParent, (Object)secondKeymap.myParent)) {
            return false;
        }
        return Comparing.equal(this.myActionId2ListOfShortcuts, secondKeymap.myActionId2ListOfShortcuts);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.myName != null) {
            hashCode += this.myName.hashCode();
        }
        return hashCode;
    }

    public Keymap getParent() {
        return this.myParent;
    }

    public boolean canModify() {
        return this.myCanModify;
    }

    public void setCanModify(boolean val) {
        this.myCanModify = val;
    }

    protected Shortcut[] getParentShortcuts(String actionId) {
        return this.myParent.getShortcuts(actionId);
    }

    public void addShortcut(String actionId, Shortcut shortcut) {
        this.addShortcutSilently(actionId, shortcut, true);
        this.fireShortcutChanged(actionId);
    }

    private void addShortcutSilently(String actionId, Shortcut shortcut, boolean checkParentShortcut) {
        List<Shortcut> list = this.myActionId2ListOfShortcuts.get(actionId);
        if (list == null) {
            list = new ArrayList<Shortcut>();
            this.myActionId2ListOfShortcuts.put(actionId, list);
            if (this.myParent != null) {
                Shortcut[] shortcuts = this.getParentShortcuts(actionId);
                list.addAll(Arrays.asList(shortcuts));
            }
        }
        list.add(shortcut);
        if (checkParentShortcut && this.myParent != null && KeymapImpl.areShortcutsEqual(this.getParentShortcuts(actionId), this.getShortcuts(actionId))) {
            this.myActionId2ListOfShortcuts.remove(actionId);
        }
        this.myKeystroke2ListOfIds = null;
        this.myMouseShortcut2ListOfIds = null;
    }

    public void removeAllActionShortcuts(String actionId) {
        Shortcut[] allShortcuts;
        for (Shortcut shortcut : allShortcuts = this.getShortcuts(actionId)) {
            this.removeShortcut(actionId, shortcut);
        }
    }

    public void removeAllActionShortcuts0(String actionId) {
        Shortcut[] allShortcuts;
        for (Shortcut shortcut : allShortcuts = this.getShortcuts(actionId)) {
            this.removeShortcut(actionId, shortcut);
        }
    }

    public void removeShortcut(String actionId, Shortcut shortcut) {
        List<Shortcut> list = this.myActionId2ListOfShortcuts.get(actionId);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!shortcut.equals(list.get(i))) continue;
                list.remove(i);
                if (this.myParent != null && KeymapImpl.areShortcutsEqual(this.getParentShortcuts(actionId), this.getShortcuts(actionId))) {
                    this.myActionId2ListOfShortcuts.remove(actionId);
                }
                break;
            }
        } else if (this.myParent != null) {
            Shortcut[] parentShortcuts = this.getParentShortcuts(actionId);
            ArrayList<Shortcut> listOfShortcuts = new ArrayList<Shortcut>();
            for (Shortcut parentShortcut : parentShortcuts) {
                if (shortcut.equals(parentShortcut)) continue;
                listOfShortcuts.add(parentShortcut);
            }
            this.myActionId2ListOfShortcuts.put(actionId, listOfShortcuts);
        }
        this.myKeystroke2ListOfIds = null;
        this.myMouseShortcut2ListOfIds = null;
        this.fireShortcutChanged(actionId);
    }

    private Map<KeyStroke, List<String>> getKeystroke2ListOfIds() {
        this.myKeystroke2ListOfIds = new THashMap();
        for (String id : ContainerUtil.concat((Iterable[])new Iterable[]{this.myActionId2ListOfShortcuts.keySet(), this.getKeymapManager().getBoundActions()})) {
            this.addKeystrokesMap(id, this.myKeystroke2ListOfIds);
        }
        return this.myKeystroke2ListOfIds;
    }

    private Map<KeyboardModifierGestureShortuct, List<String>> getGesture2ListOfIds() {
        if (this.myGesture2ListOfIds == null) {
            this.myGesture2ListOfIds = new THashMap();
            this.fillShortcut2ListOfIds(this.myGesture2ListOfIds, KeyboardModifierGestureShortuct.class);
        }
        return this.myGesture2ListOfIds;
    }

    private <T extends Shortcut> void fillShortcut2ListOfIds(Map<T, List<String>> map, Class<T> shortcutClass) {
        for (String id : ContainerUtil.concat((Iterable[])new Iterable[]{this.myActionId2ListOfShortcuts.keySet(), this.getKeymapManager().getBoundActions()})) {
            this.addAction2ShortcutsMap(id, map, shortcutClass);
        }
    }

    private Map<MouseShortcut, List<String>> getMouseShortcut2ListOfIds() {
        if (this.myMouseShortcut2ListOfIds == null) {
            this.myMouseShortcut2ListOfIds = new THashMap();
            this.fillShortcut2ListOfIds(this.myMouseShortcut2ListOfIds, MouseShortcut.class);
        }
        return this.myMouseShortcut2ListOfIds;
    }

    private <T extends Shortcut> void addAction2ShortcutsMap(String actionId, Map<T, List<String>> strokesMap, Class<T> shortcutClass) {
        List<Shortcut> listOfShortcuts = this._getShortcuts(actionId);
        for (Shortcut shortcut : listOfShortcuts) {
            if (!shortcutClass.isAssignableFrom(shortcut.getClass())) continue;
            Shortcut t = shortcut;
            List<String> listOfIds = strokesMap.get(t);
            if (listOfIds == null) {
                listOfIds = new ArrayList<String>();
                strokesMap.put(t, listOfIds);
            }
            if (listOfIds.contains(actionId)) continue;
            listOfIds.add(actionId);
        }
    }

    private void addKeystrokesMap(String actionId, Map<KeyStroke, List<String>> strokesMap) {
        List<Shortcut> listOfShortcuts = this._getShortcuts(actionId);
        for (Shortcut shortcut : listOfShortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke firstKeyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            List<String> listOfIds = strokesMap.get(firstKeyStroke);
            if (listOfIds == null) {
                listOfIds = new ArrayList<String>();
                strokesMap.put(firstKeyStroke, listOfIds);
            }
            if (listOfIds.contains(actionId)) continue;
            listOfIds.add(actionId);
        }
    }

    private List<Shortcut> _getShortcuts(String actionId) {
        KeymapManagerEx keymapManager = this.getKeymapManager();
        List<Shortcut> listOfShortcuts = this.myActionId2ListOfShortcuts.get(actionId);
        listOfShortcuts = listOfShortcuts != null ? new ArrayList<Shortcut>(listOfShortcuts) : new ArrayList<Shortcut>();
        String actionBinding = keymapManager.getActionBinding(actionId);
        if (actionBinding != null) {
            listOfShortcuts.addAll(this._getShortcuts(actionBinding));
        }
        return listOfShortcuts;
    }

    protected String[] getParentActionIds(KeyStroke firstKeyStroke) {
        return this.myParent.getActionIds(firstKeyStroke);
    }

    protected String[] getParentActionIds(KeyboardModifierGestureShortuct gesture) {
        return this.myParent.getActionIds(gesture);
    }

    private String[] getActionIds(KeyboardModifierGestureShortuct shortuct) {
        String[] ids;
        Map<KeyboardModifierGestureShortuct, List<String>> map = this.getGesture2ListOfIds();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<KeyboardModifierGestureShortuct, List<String>> entry : map.entrySet()) {
            if (!shortuct.startsWith((Shortcut)entry.getKey())) continue;
            list.addAll((Collection)entry.getValue());
        }
        if (this.myParent != null && (ids = this.getParentActionIds(shortuct)).length > 0) {
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey(id)) continue;
                list.add(id);
            }
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    public String[] getActionIds(KeyStroke firstKeyStroke) {
        String[] ids;
        List<String> list = this.getKeystroke2ListOfIds().get(firstKeyStroke);
        if (this.myParent != null && (ids = this.getParentActionIds(firstKeyStroke)).length > 0) {
            boolean originalListInstance = true;
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey(id)) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                    originalListInstance = false;
                } else if (originalListInstance) {
                    list = new ArrayList<String>(list);
                    originalListInstance = false;
                }
                if (list.contains(id)) continue;
                list.add(id);
            }
        }
        if (list == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    public String[] getActionIds(KeyStroke firstKeyStroke, KeyStroke secondKeyStroke) {
        String[] ids = this.getActionIds(firstKeyStroke);
        ArrayList<String> actualBindings = new ArrayList<String>();
        block0: for (String id : ids) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = this.getShortcuts(id)) {
                if (!(shortcut instanceof KeyboardShortcut) || !Comparing.equal((Object)firstKeyStroke, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()) || !Comparing.equal((Object)secondKeyStroke, (Object)((KeyboardShortcut)shortcut).getSecondKeyStroke())) continue;
                actualBindings.add(id);
                continue block0;
            }
        }
        return ArrayUtil.toStringArray(actualBindings);
    }

    public String[] getActionIds(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut kb = (KeyboardShortcut)shortcut;
            KeyStroke first = kb.getFirstKeyStroke();
            KeyStroke second = kb.getSecondKeyStroke();
            return second != null ? this.getActionIds(first, second) : this.getActionIds(first);
        }
        if (shortcut instanceof MouseShortcut) {
            return this.getActionIds((MouseShortcut)shortcut);
        }
        if (shortcut instanceof KeyboardModifierGestureShortuct) {
            return this.getActionIds((KeyboardModifierGestureShortuct)shortcut);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected String[] getParentActionIds(MouseShortcut shortcut) {
        return this.myParent.getActionIds(shortcut);
    }

    public String[] getActionIds(MouseShortcut shortcut) {
        String[] ids;
        List<String> list = this.getMouseShortcut2ListOfIds().get(shortcut);
        if (this.myParent != null && (ids = this.getParentActionIds(shortcut)).length > 0) {
            boolean originalListInstance = true;
            for (String id : ids) {
                if (this.myActionId2ListOfShortcuts.containsKey(id)) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                    originalListInstance = false;
                } else if (originalListInstance) {
                    list = new ArrayList<String>(list);
                }
                list.add(id);
            }
        }
        if (list == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return KeymapImpl.sortInOrderOfRegistration(ArrayUtil.toStringArray(list));
    }

    private static String[] sortInOrderOfRegistration(String[] ids) {
        Arrays.sort(ids, ActionManagerEx.getInstanceEx().getRegistrationOrderComparator());
        return ids;
    }

    public Shortcut[] getShortcuts(String actionId) {
        KeymapManagerEx keymapManager = this.getKeymapManager();
        if (keymapManager.getBoundActions().contains(actionId)) {
            return this.getShortcuts(keymapManager.getActionBinding(actionId));
        }
        List<Shortcut> shortcuts = this.myActionId2ListOfShortcuts.get(actionId);
        if (shortcuts == null) {
            if (this.myParent != null) {
                return this.getParentShortcuts(actionId);
            }
            return ourEmptyShortcutsArray;
        }
        return shortcuts.toArray(new Shortcut[shortcuts.size()]);
    }

    private KeymapManagerEx getKeymapManager() {
        if (this.myKeymapManager == null) {
            this.myKeymapManager = KeymapManagerEx.getInstanceEx();
        }
        return this.myKeymapManager;
    }

    public void readExternal(Element keymapElement, Keymap[] existingKeymaps) throws InvalidDataException {
        String parentName;
        if (!KEY_MAP.equals(keymapElement.getName())) {
            throw new InvalidDataException("unknown element: " + keymapElement);
        }
        if (keymapElement.getAttributeValue(VERSION_ATTRIBUTE) == null) {
            Converter01.convert(keymapElement);
        }
        if ((parentName = keymapElement.getAttributeValue(PARENT_ATTRIBUTE)) != null) {
            for (Keymap existingKeymap : existingKeymaps) {
                if (!parentName.equals(existingKeymap.getName())) continue;
                this.myParent = (KeymapImpl)existingKeymap;
                this.myCanModify = true;
                break;
            }
        }
        this.myName = keymapElement.getAttributeValue(NAME_ATTRIBUTE);
        HashMap id2shortcuts = new HashMap();
        for (Object o : keymapElement.getChildren()) {
            Element actionElement = (Element)o;
            if (ACTION.equals(actionElement.getName())) {
                String id = actionElement.getAttributeValue(ID_ATTRIBUTE);
                if (id == null) {
                    throw new InvalidDataException("Attribute 'id' cannot be null; Keymap's name=" + this.myName);
                }
                id2shortcuts.put(id, new ArrayList(1));
                for (Object o1 : actionElement.getChildren()) {
                    ArrayList shortcuts;
                    KeyboardShortcut shortcut;
                    Element shortcutElement = (Element)o1;
                    if (KEYBOARD_SHORTCUT.equals(shortcutElement.getName())) {
                        KeyStroke firstKeyStroke;
                        String firstKeyStrokeStr = shortcutElement.getAttributeValue(FIRST_KEYSTROKE_ATTRIBUTE);
                        if (firstKeyStrokeStr != null) {
                            firstKeyStroke = ActionManagerEx.getKeyStroke(firstKeyStrokeStr);
                            if (firstKeyStroke == null) {
                                throw new InvalidDataException("Cannot parse first-keystroke: '" + firstKeyStrokeStr + "'; " + "Action's id=" + id + "; Keymap's name=" + this.myName);
                            }
                        } else {
                            throw new InvalidDataException("Attribute 'first-keystroke' cannot be null; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        KeyStroke secondKeyStroke = null;
                        String secondKeyStrokeStr = shortcutElement.getAttributeValue(SECOND_KEYSTROKE_ATTRIBUTE);
                        if (secondKeyStrokeStr != null && (secondKeyStroke = ActionManagerEx.getKeyStroke(secondKeyStrokeStr)) == null) {
                            throw new InvalidDataException("Wrong second-keystroke: '" + secondKeyStrokeStr + "'; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
                        shortcuts = (ArrayList)id2shortcuts.get(id);
                        shortcuts.add(shortcut);
                        continue;
                    }
                    if (KEYBOARD_GESTURE_SHORTCUT.equals(shortcutElement.getName())) {
                        KeyStroke stroke = null;
                        String strokeText = shortcutElement.getAttributeValue("keystroke");
                        if (strokeText != null) {
                            stroke = ActionManagerEx.getKeyStroke(strokeText);
                        }
                        String modifierText = shortcutElement.getAttributeValue(KEYBOARD_GESTURE_MODIFIER);
                        KeyboardGestureAction.ModifierType modifier = null;
                        if (KeyboardGestureAction.ModifierType.dblClick.toString().equalsIgnoreCase(modifierText)) {
                            modifier = KeyboardGestureAction.ModifierType.dblClick;
                        } else if (KeyboardGestureAction.ModifierType.hold.toString().equalsIgnoreCase(modifierText)) {
                            modifier = KeyboardGestureAction.ModifierType.hold;
                        }
                        if (stroke == null) {
                            throw new InvalidDataException("Wrong keystroke=" + strokeText + " action id=" + id + " keymap=" + this.myName);
                        }
                        if (modifier == null) {
                            throw new InvalidDataException("Wrong modifier=" + modifierText + " action id=" + id + " keymap=" + this.myName);
                        }
                        shortcut = KeyboardModifierGestureShortuct.newInstance((KeyboardGestureAction.ModifierType)modifier, (KeyStroke)stroke);
                        shortcuts = (ArrayList)id2shortcuts.get(id);
                        shortcuts.add(shortcut);
                        continue;
                    }
                    if (MOUSE_SHORTCUT.equals(shortcutElement.getName())) {
                        String keystrokeString = shortcutElement.getAttributeValue("keystroke");
                        if (keystrokeString == null) {
                            throw new InvalidDataException("Attribute 'keystroke' cannot be null; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                        try {
                            MouseShortcut shortcut2 = KeymapUtil.parseMouseShortcut((String)keystrokeString);
                            ArrayList shortcuts2 = (ArrayList)id2shortcuts.get(id);
                            shortcuts2.add(shortcut2);
                            continue;
                        }
                        catch (InvalidDataException exc) {
                            throw new InvalidDataException("Wrong mouse-shortcut: '" + keystrokeString + "'; Action's id=" + id + "; Keymap's name=" + this.myName);
                        }
                    }
                    throw new InvalidDataException("unknown element: " + shortcutElement + "; Keymap's name=" + this.myName);
                }
                continue;
            }
            throw new InvalidDataException("unknown element: " + actionElement + "; Keymap's name=" + this.myName);
        }
        for (String id : id2shortcuts.keySet()) {
            this.myActionId2ListOfShortcuts.put(id, new ArrayList(2));
            ArrayList shortcuts = (ArrayList)id2shortcuts.get(id);
            for (Shortcut shortcut : shortcuts) {
                this.addShortcutSilently(id, shortcut, false);
            }
        }
    }

    public Element writeExternal() {
        Element keymapElement = new Element(KEY_MAP);
        keymapElement.setAttribute(VERSION_ATTRIBUTE, Integer.toString(1));
        keymapElement.setAttribute(NAME_ATTRIBUTE, this.myName);
        if (this.myParent != null) {
            keymapElement.setAttribute(PARENT_ATTRIBUTE, this.myParent.getName());
        }
        this.writeOwnActionIds(keymapElement);
        return keymapElement;
    }

    private void writeOwnActionIds(Element keymapElement) {
        Object[] ownActionIds = this.getOwnActionIds();
        Arrays.sort(ownActionIds);
        for (Object actionId : ownActionIds) {
            Shortcut[] shortcuts;
            Element actionElement = new Element(ACTION);
            actionElement.setAttribute(ID_ATTRIBUTE, (String)actionId);
            for (Shortcut shortcut : shortcuts = this.getShortcuts((String)actionId)) {
                Element element;
                if (shortcut instanceof KeyboardShortcut) {
                    KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
                    element = new Element(KEYBOARD_SHORTCUT);
                    element.setAttribute(FIRST_KEYSTROKE_ATTRIBUTE, KeymapImpl.getKeyShortcutString(keyboardShortcut.getFirstKeyStroke()));
                    if (keyboardShortcut.getSecondKeyStroke() != null) {
                        element.setAttribute(SECOND_KEYSTROKE_ATTRIBUTE, KeymapImpl.getKeyShortcutString(keyboardShortcut.getSecondKeyStroke()));
                    }
                    actionElement.addContent(element);
                    continue;
                }
                if (shortcut instanceof MouseShortcut) {
                    MouseShortcut mouseShortcut = (MouseShortcut)shortcut;
                    element = new Element(MOUSE_SHORTCUT);
                    element.setAttribute("keystroke", KeymapImpl.getMouseShortcutString(mouseShortcut));
                    actionElement.addContent(element);
                    continue;
                }
                if (shortcut instanceof KeyboardModifierGestureShortuct) {
                    KeyboardModifierGestureShortuct gesture = (KeyboardModifierGestureShortuct)shortcut;
                    element = new Element(KEYBOARD_GESTURE_SHORTCUT);
                    element.setAttribute(KEYBOARD_GESTURE_SHORTCUT, KeymapImpl.getKeyShortcutString(gesture.getStroke()));
                    element.setAttribute(KEYBOARD_GESTURE_MODIFIER, gesture.getType().name());
                    actionElement.addContent(element);
                    continue;
                }
                throw new IllegalStateException("unknown shortcut class: " + shortcut);
            }
            keymapElement.addContent(actionElement);
        }
    }

    private static boolean areShortcutsEqual(Shortcut[] shortcuts1, Shortcut[] shortcuts2) {
        if (shortcuts1.length != shortcuts2.length) {
            return false;
        }
        for (Shortcut shortcut : shortcuts1) {
            Shortcut parentShortcutEqual = null;
            for (Shortcut parentShortcut : shortcuts2) {
                if (!shortcut.equals(parentShortcut)) continue;
                parentShortcutEqual = parentShortcut;
                break;
            }
            if (parentShortcutEqual != null) continue;
            return false;
        }
        return true;
    }

    public static String getKeyShortcutString(KeyStroke keyStroke) {
        StringBuffer buf = new StringBuffer();
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 1) != 0) {
            buf.append(SHIFT);
            buf.append(' ');
        }
        if ((modifiers & 2) != 0) {
            buf.append(CONTROL);
            buf.append(' ');
        }
        if ((modifiers & 4) != 0) {
            buf.append(META);
            buf.append(' ');
        }
        if ((modifiers & 8) != 0) {
            buf.append(ALT);
            buf.append(' ');
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(ALT_GRAPH);
            buf.append(' ');
        }
        buf.append(ourNamesForKeycodes.get(keyStroke.getKeyCode()));
        return buf.toString();
    }

    private static String getMouseShortcutString(MouseShortcut shortcut) {
        int button;
        StringBuffer buffer = new StringBuffer();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        if (1 == (button = shortcut.getButton())) {
            buffer.append(BUTTON1);
            buffer.append(' ');
        } else if (2 == button) {
            buffer.append(BUTTON2);
            buffer.append(' ');
        } else if (3 == button) {
            buffer.append(BUTTON3);
            buffer.append(' ');
        } else {
            throw new IllegalStateException("unknown button: " + button);
        }
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        return buffer.toString().trim();
    }

    public String[] getOwnActionIds() {
        return this.myActionId2ListOfShortcuts.keySet().toArray(new String[this.myActionId2ListOfShortcuts.size()]);
    }

    public void clearOwnActionsIds() {
        this.myActionId2ListOfShortcuts.clear();
    }

    public String[] getActionIds() {
        String[] ownActionIds;
        ArrayList<String> ids = new ArrayList<String>();
        if (this.myParent != null) {
            String[] parentIds = this.getParentActionIds();
            ids.addAll(Arrays.asList(parentIds));
        }
        for (String id : ownActionIds = this.getOwnActionIds()) {
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ArrayUtil.toStringArray(ids);
    }

    protected String[] getParentActionIds() {
        return this.myParent.getActionIds();
    }

    public HashMap<String, ArrayList<KeyboardShortcut>> getConflicts(String actionId, KeyboardShortcut keyboardShortcut) {
        String[] actionIds;
        HashMap result = new HashMap();
        for (String id : actionIds = this.getActionIds(keyboardShortcut.getFirstKeyStroke())) {
            Shortcut[] shortcuts;
            if (id.equals(actionId) || actionId.startsWith(EDITOR_ACTION_PREFIX) && id.equals("$" + actionId.substring(6)) || StringUtil.startsWithChar((CharSequence)actionId, (char)'$') && id.equals(EDITOR_ACTION_PREFIX + actionId.substring(1))) continue;
            for (Shortcut shortcut1 : shortcuts = this.getShortcuts(id)) {
                KeyboardShortcut shortcut;
                if (!(shortcut1 instanceof KeyboardShortcut) || !(shortcut = (KeyboardShortcut)shortcut1).getFirstKeyStroke().equals(keyboardShortcut.getFirstKeyStroke()) || keyboardShortcut.getSecondKeyStroke() != null && shortcut.getSecondKeyStroke() != null && !keyboardShortcut.getSecondKeyStroke().equals(shortcut.getSecondKeyStroke())) continue;
                ArrayList<KeyboardShortcut> list = (ArrayList<KeyboardShortcut>)result.get((Object)id);
                if (list == null) {
                    list = new ArrayList<KeyboardShortcut>();
                    result.put((Object)id, list);
                }
                list.add(shortcut);
            }
        }
        return result;
    }

    public void addShortcutChangeListener(Keymap.Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeShortcutChangeListener(Keymap.Listener listener) {
        this.myListeners.remove(listener);
    }

    private void fireShortcutChanged(String actionId) {
        Keymap.Listener[] listeners;
        for (Keymap.Listener listener : listeners = this.myListeners.toArray(new Keymap.Listener[this.myListeners.size()])) {
            listener.onShortcutChanged(actionId);
        }
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/keymap/impl/KeymapImpl.getExternalInfo must not return null");
        }
        return externalInfo;
    }

    public String toString() {
        return this.getPresentableName();
    }

    static {
        ourEmptyShortcutsArray = new Shortcut[0];
        ourNamesForKeycodes = new HashMap();
        try {
            Field[] fields;
            for (Field field : fields = KeyEvent.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!fieldName.startsWith(VIRTUAL_KEY_PREFIX)) continue;
                int keyCode = field.getInt(KeyEvent.class);
                ourNamesForKeycodes.put(keyCode, fieldName.substring(3));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

