/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultModulesProvider
implements ModulesProvider {
    private final Project myProject;

    public DefaultModulesProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider.getModules must not return null");
        }
        return moduleArray;
    }

    public Module getModule(String name) {
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(name);
    }

    public ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider.getRootModel must not be null");
        }
        return ModuleRootManager.getInstance((Module)module);
    }

    public FacetModel getFacetModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider.getFacetModel must not be null");
        }
        return FacetManager.getInstance((Module)module);
    }
}

