/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public abstract class EditChangelistPanel {
    private JTextField myNameTextField;
    private JTextArea myDescriptionTextArea;
    private JPanel myContent;
    private JPanel myAdditionalControlsPanel;
    private JCheckBox myMakeActiveCheckBox;
    @Nullable
    private final ChangeListEditHandler myHandler;
    private Consumer<LocalChangeList> myConsumer;

    public EditChangelistPanel(@Nullable ChangeListEditHandler handler) {
        this.myHandler = handler;
        this.$$$setupUI$$$();
        this.myNameTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                EditChangelistPanel.this.onEditName(EditChangelistPanel.this.myHandler);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditChangelistPanel.this.onEditName(EditChangelistPanel.this.myHandler);
            }
        });
        this.myNameTextField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                EditChangelistPanel.this.onEditName(EditChangelistPanel.this.myHandler);
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        if (this.myHandler != null) {
            this.myDescriptionTextArea.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    EditChangelistPanel.this.onEditComment(EditChangelistPanel.this.myHandler);
                }
            });
            this.myDescriptionTextArea.addInputMethodListener(new InputMethodListener(){

                @Override
                public void inputMethodTextChanged(InputMethodEvent event) {
                    EditChangelistPanel.this.onEditComment(EditChangelistPanel.this.myHandler);
                }

                @Override
                public void caretPositionChanged(InputMethodEvent event) {
                }
            });
        }
    }

    public JCheckBox getMakeActiveCheckBox() {
        return this.myMakeActiveCheckBox;
    }

    public void init(final Project project, final LocalChangeList initial) {
        this.myMakeActiveCheckBox.setSelected(VcsConfiguration.getInstance((Project)project).MAKE_NEW_CHANGELIST_ACTIVE);
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)project)) {
            support.installSearch(this.myNameTextField, this.myDescriptionTextArea);
            this.myConsumer = support.addControls(this.myAdditionalControlsPanel, initial);
        }
        this.myNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditChangelistPanel.this.nameChangedImpl(project, initial);
            }
        });
        this.nameChangedImpl(project, initial);
    }

    protected void nameChangedImpl(Project project, LocalChangeList initial) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            this.nameChanged("Cannot create new changelist with empty name.");
        } else if (!(initial != null && name.equals(initial.getName()) || ChangeListManager.getInstance((Project)project).findChangeList(name) == null)) {
            this.nameChanged(VcsBundle.message((String)"new.changelist.duplicate.name.error", (Object[])new Object[0]));
        } else {
            this.nameChanged(null);
        }
    }

    public void changelistCreatedOrChanged(LocalChangeList list) {
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)list);
        }
    }

    private void onEditComment(ChangeListEditHandler handler) {
        if (handler != null) {
            this.myNameTextField.setText(handler.changeNameOnChangeComment(this.myNameTextField.getText(), this.myDescriptionTextArea.getText()));
        }
    }

    private void onEditName(ChangeListEditHandler handler) {
        if (handler != null) {
            this.myDescriptionTextArea.setText(handler.changeCommentOnChangeName(this.myNameTextField.getText(), this.myDescriptionTextArea.getText()));
        }
    }

    public void setName(String s) {
        this.myNameTextField.setText(s);
    }

    public String getName() {
        return this.myNameTextField.getText();
    }

    public void setDescription(String s) {
        this.myDescriptionTextArea.setText(s);
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText();
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public void setEnabled(boolean b) {
        UIUtil.setEnabled((Component)this.myContent, (boolean)b, (boolean)true);
    }

    public void requestFocus() {
        this.myNameTextField.requestFocus();
    }

    public JComponent getPrefferedFocusedComponent() {
        return this.myNameTextField;
    }

    protected abstract void nameChanged(String var1);

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel2;
        this.myContent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/VcsBundle").getString("edit.changelist.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/VcsBundle").getString("edit.changelist.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myDescriptionTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setColumns(50);
        jScrollPane.setViewportView(jTextArea);
        this.myAdditionalControlsPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 8, 2, 3, 3, null, null, null));
        this.myMakeActiveCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("new.changelist.make.active.checkbox"));
        Component component = jPanel.add(jCheckBox);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

