/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.LocalFileStorage;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.VirtualFileImpl;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteFileManager {
    private final LocalFileStorage myStorage;
    private final HttpFileSystemImpl myHttpFileSystem;
    private final Map<Pair<Boolean, String>, VirtualFileImpl> myRemoteFiles;

    public RemoteFileManager(HttpFileSystemImpl httpFileSystem) {
        this.myHttpFileSystem = httpFileSystem;
        this.myStorage = new LocalFileStorage();
        this.myRemoteFiles = new THashMap();
    }

    public synchronized VirtualFileImpl getOrCreateFile(@NotNull String url, @NotNull String path, boolean directory) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileManager.getOrCreateFile must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/http/RemoteFileManager.getOrCreateFile must not be null");
        }
        Pair key = Pair.create((Object)directory, (Object)url);
        VirtualFileImpl file = this.myRemoteFiles.get(key);
        if (file == null) {
            if (!directory) {
                RemoteFileInfo fileInfo = new RemoteFileInfo(url, this);
                file = new VirtualFileImpl(this.myHttpFileSystem, path, fileInfo);
                fileInfo.addDownloadingListener(new MyDownloadingListener(this.myHttpFileSystem, file));
            } else {
                file = new VirtualFileImpl(this.myHttpFileSystem, path, null);
            }
            this.myRemoteFiles.put((Pair<Boolean, String>)key, file);
        }
        return file;
    }

    public LocalFileStorage getStorage() {
        return this.myStorage;
    }

    private static class MyDownloadingListener
    extends FileDownloadingAdapter {
        private final HttpFileSystemImpl myHttpFileSystem;
        private final VirtualFileImpl myFile;

        public MyDownloadingListener(HttpFileSystemImpl httpFileSystem, VirtualFileImpl file) {
            this.myHttpFileSystem = httpFileSystem;
            this.myFile = file;
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            this.myHttpFileSystem.fireFileDownloaded((VirtualFile)this.myFile);
        }
    }
}

