/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.ex.WeakKeymapManagerListener;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class Stripe
extends JPanel {
    private final int myAnchor;
    private final ArrayList<StripeButton> myButtons = new ArrayList();
    private final MyKeymapManagerListener myKeymapManagerListener;
    private final WeakKeymapManagerListener myWeakKeymapManagerListener;
    private final MyUISettingsListener myUISettingsListener;
    private Dimension myPrefSize;
    private StripeButton myDragButton;
    private Rectangle myDropRectangle;
    private final ToolWindowManagerImpl myManager;
    private JComponent myDragButtonImage;
    private LayoutData myLastLayoutData;
    private boolean myFinishingDrop;
    static final int DROP_DISTANCE_SENSIVITY = 20;

    Stripe(int anchor, ToolWindowManagerImpl manager) {
        super(new GridBagLayout());
        this.myManager = manager;
        this.myAnchor = anchor;
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myWeakKeymapManagerListener = new WeakKeymapManagerListener(KeymapManagerEx.getInstanceEx(), this.myKeymapManagerListener);
        this.myUISettingsListener = new MyUISettingsListener();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateText();
        this.updateState();
        KeymapManagerEx.getInstanceEx().addKeymapManagerListener(this.myWeakKeymapManagerListener);
        UISettings.getInstance().addUISettingsListener((UISettingsListener)this.myUISettingsListener);
    }

    @Override
    public void removeNotify() {
        KeymapManagerEx.getInstanceEx().removeKeymapManagerListener(this.myWeakKeymapManagerListener);
        UISettings.getInstance().removeUISettingsListener((UISettingsListener)this.myUISettingsListener);
        super.removeNotify();
    }

    void addButton(StripeButton button, Comparator comparator) {
        this.myPrefSize = null;
        this.myButtons.add(button);
        Collections.sort(this.myButtons, comparator);
        this.add(button);
        this.revalidate();
    }

    void removeButton(StripeButton button) {
        this.myPrefSize = null;
        this.myButtons.remove(button);
        this.remove(button);
        this.revalidate();
    }

    public List<StripeButton> getButtons() {
        return Collections.unmodifiableList(this.myButtons);
    }

    @Override
    public void invalidate() {
        this.myPrefSize = null;
        super.invalidate();
    }

    @Override
    public void doLayout() {
        if (!this.myFinishingDrop) {
            this.myLastLayoutData = this.recomputeBounds(true, this.getSize());
        }
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith) {
        return this.recomputeBounds(setBounds, toFitWith, false);
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith, boolean noDrop) {
        boolean processDrop;
        LayoutData data = new LayoutData();
        data.eachY = 0;
        data.size = new Dimension();
        data.gap = 1;
        data.horizontal = this.isHorizontal();
        data.dragInsertPosition = -1;
        if (data.horizontal) {
            this.myManager.getToolWindowsPane();
            data.eachX = ToolWindowsPane.getHorizontalInsetX();
        } else {
            data.eachX = 0;
        }
        data.fitSize = toFitWith != null ? toFitWith : new Dimension();
        Rectangle stripeSensetiveRec = new Rectangle(-20, -20, this.getWidth() + 40, this.getHeight() + 40);
        boolean bl = processDrop = this.isDroppingButton() && stripeSensetiveRec.intersects(this.myDropRectangle) && !noDrop;
        if (toFitWith == null) {
            for (StripeButton eachButton : this.myButtons) {
                if (!this.isConsideredInLayout(eachButton)) continue;
                Dimension eachSize = eachButton.getPreferredSize();
                data.fitSize.width = Math.max(eachSize.width, data.fitSize.width);
                data.fitSize.height = Math.max(eachSize.height, data.fitSize.height);
            }
        }
        int gap = 0;
        if (toFitWith != null) {
            LayoutData layoutData = this.recomputeBounds(false, null, true);
            if (data.horizontal) {
                int n = toFitWith.width;
                this.myManager.getToolWindowsPane();
                gap = n - ToolWindowsPane.getHorizontalInsetX() - layoutData.size.width - data.eachX;
            } else {
                gap = toFitWith.height - layoutData.size.height - data.eachY;
            }
            if (processDrop) {
                gap = data.horizontal ? (gap -= this.myDropRectangle.width + data.gap) : (gap -= this.myDropRectangle.height + data.gap);
            }
            gap = Math.max(gap, 0);
        }
        int insertOrder = -1;
        boolean sidesStarted = false;
        for (StripeButton eachButton : this.getButtonsToLayOut()) {
            insertOrder = eachButton.getDecorator().getWindowInfo().getOrder();
            Dimension eachSize = eachButton.getPreferredSize();
            if (!sidesStarted && eachButton.getWindowInfo().isSplit()) {
                if (processDrop) {
                    this.tryDroppingOnGap(data, gap, eachButton.getWindowInfo().getOrder());
                }
                if (data.horizontal) {
                    data.eachX += gap;
                    data.size.width += gap;
                } else {
                    data.eachY += gap;
                    data.size.height += gap;
                }
                sidesStarted = true;
            }
            if (processDrop && !data.dragTargetChoosen) {
                int distance;
                if (data.horizontal) {
                    distance = this.myDropRectangle.x - data.eachX;
                    if (distance < eachSize.width / 2 || this.myDropRectangle.x + this.myDropRectangle.width < eachSize.width / 2) {
                        Stripe.layoutButton(data, this.myDragButtonImage, false);
                        data.dragInsertPosition = insertOrder;
                        data.dragToSide = sidesStarted;
                        data.dragTargetChoosen = true;
                    }
                } else {
                    distance = this.myDropRectangle.y - data.eachY;
                    if (distance < eachSize.height / 2 || this.myDropRectangle.y + this.myDropRectangle.height < eachSize.height / 2) {
                        Stripe.layoutButton(data, this.myDragButtonImage, false);
                        data.dragInsertPosition = insertOrder;
                        data.dragToSide = sidesStarted;
                        data.dragTargetChoosen = true;
                    }
                }
            }
            Stripe.layoutButton(data, eachButton, setBounds);
        }
        if (!sidesStarted && processDrop) {
            this.tryDroppingOnGap(data, gap, -1);
        }
        if (this.isDroppingButton()) {
            Dimension dragSize = this.myDragButton.getPreferredSize();
            if (this.getAnchor().isHorizontal() == this.myDragButton.getWindowInfo().getAnchor().isHorizontal()) {
                data.size.width = Math.max(data.size.width, dragSize.width);
                data.size.height = Math.max(data.size.height, dragSize.height);
            } else {
                data.size.width = Math.max(data.size.width, dragSize.height);
                data.size.height = Math.max(data.size.height, dragSize.width);
            }
        }
        if (processDrop && !data.dragTargetChoosen) {
            data.dragInsertPosition = -1;
            data.dragToSide = true;
            data.dragTargetChoosen = true;
        }
        return data;
    }

    private void tryDroppingOnGap(LayoutData data, int gap, int insertOrder) {
        int sideDistance;
        int nonSideDistance;
        if (data.dragTargetChoosen) {
            return;
        }
        if (data.horizontal) {
            nonSideDistance = this.myDropRectangle.x - data.eachX;
            sideDistance = data.eachX + gap - this.myDropRectangle.x;
        } else {
            nonSideDistance = this.myDropRectangle.y - data.eachY;
            sideDistance = data.eachY + gap - this.myDropRectangle.y;
        }
        nonSideDistance = Math.max(0, nonSideDistance);
        if (sideDistance > 0) {
            if (nonSideDistance > sideDistance) {
                data.dragInsertPosition = insertOrder;
                data.dragToSide = true;
                data.dragTargetChoosen = true;
            } else {
                data.dragInsertPosition = -1;
                data.dragToSide = false;
                data.dragTargetChoosen = true;
            }
            Stripe.layoutButton(data, this.myDragButtonImage, false);
        }
    }

    private List<StripeButton> getButtonsToLayOut() {
        ArrayList<StripeButton> result = new ArrayList<StripeButton>();
        ArrayList<StripeButton> tools = new ArrayList<StripeButton>();
        ArrayList<StripeButton> sideTools = new ArrayList<StripeButton>();
        for (StripeButton b : this.myButtons) {
            if (!this.isConsideredInLayout(b)) continue;
            if (b.getWindowInfo().isSplit()) {
                sideTools.add(b);
                continue;
            }
            tools.add(b);
        }
        result.addAll(tools);
        result.addAll(sideTools);
        return result;
    }

    public ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.get((int)this.myAnchor);
    }

    private static void layoutButton(LayoutData data, JComponent eachButton, boolean setBounds) {
        Dimension eachSize = eachButton.getPreferredSize();
        if (setBounds) {
            int width = data.horizontal ? eachSize.width : data.fitSize.width;
            int height = data.horizontal ? data.fitSize.height : eachSize.height;
            eachButton.setBounds(data.eachX, data.eachY, width, height);
        }
        if (data.horizontal) {
            int deltaX = eachSize.width + data.gap;
            data.eachX += deltaX;
            data.size.width += deltaX;
            data.size.height = eachSize.height;
        } else {
            int deltaY = eachSize.height + data.gap;
            data.eachY += deltaY;
            data.size.width = eachSize.width;
            data.size.height += deltaY;
        }
        ++data.processedComponents;
    }

    public void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public void stopDrag() {
        this.revalidate();
        this.repaint();
    }

    public StripeButton getButtonFor(String toolWindowId) {
        for (StripeButton each : this.myButtons) {
            if (!each.getWindowInfo().getId().equals(toolWindowId)) continue;
            return each;
        }
        return null;
    }

    private boolean isHorizontal() {
        return this.myAnchor == 1 || this.myAnchor == 3;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myPrefSize == null) {
            this.myPrefSize = this.recomputeBounds((boolean)false, null).size;
        }
        return this.myPrefSize;
    }

    private void updateText() {
        int size = this.myButtons.size();
        for (int i = 0; i < size; ++i) {
            this.myButtons.get(i).updateText();
        }
    }

    void updateState() {
        int size = this.myButtons.size();
        for (int i = 0; i < size; ++i) {
            this.myButtons.get(i).updateState();
        }
    }

    public boolean containsScreen(Rectangle screenRec) {
        Point point = screenRec.getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return new Rectangle(point, screenRec.getSize()).intersects(new Rectangle(-20, -20, this.getWidth() + 20, this.getHeight() + 20));
    }

    public void finishDrop() {
        if (this.myLastLayoutData == null) {
            return;
        }
        WindowInfoImpl info = this.myDragButton.getDecorator().getWindowInfo();
        this.myFinishingDrop = true;
        this.myManager.setSideToolAndAnchor(info.getId(), ToolWindowAnchor.get((int)this.myAnchor), this.myLastLayoutData.dragInsertPosition, this.myLastLayoutData.dragToSide);
        this.myManager.invokeLater(new Runnable(){

            @Override
            public void run() {
                Stripe.this.resetDrop();
            }
        });
    }

    public void resetDrop() {
        this.myDragButton = null;
        this.myDragButtonImage = null;
        this.myFinishingDrop = false;
        this.myPrefSize = null;
        this.revalidate();
        this.repaint();
    }

    public void processDropButton(StripeButton button, JComponent buttonImage, Point screenPoint) {
        if (!this.isDroppingButton()) {
            BufferedImage image = new BufferedImage(button.getWidth(), button.getHeight(), 1);
            buttonImage.paint(image.getGraphics());
            this.myDragButton = button;
            this.myDragButtonImage = buttonImage;
            this.myPrefSize = null;
        }
        Point point = new Point(screenPoint);
        SwingUtilities.convertPointFromScreen(point, this);
        this.myDropRectangle = new Rectangle(point, buttonImage.getSize());
        this.revalidate();
        this.repaint();
    }

    private boolean isDroppingButton() {
        return this.myDragButton != null;
    }

    private boolean isConsideredInLayout(StripeButton each) {
        return each.isVisible();
    }

    @Override
    public String toString() {
        String anchor = null;
        switch (this.myAnchor) {
            case 1: {
                anchor = "TOP";
                break;
            }
            case 3: {
                anchor = "BOTTOM";
                break;
            }
            case 2: {
                anchor = "LEFT";
                break;
            }
            case 4: {
                anchor = "RIGHT";
            }
        }
        return this.getClass().getName() + " " + anchor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myFinishingDrop && this.isDroppingButton() && this.myDragButton.getParent() != this) {
            g.setColor(this.getBackground().brighter());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings source) {
            Stripe.this.updateText();
            Stripe.this.updateState();
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            Stripe.this.updateText();
        }
    }

    private static class LayoutData {
        int eachX;
        int eachY;
        int gap;
        Dimension size;
        Dimension fitSize;
        boolean horizontal;
        int processedComponents;
        boolean dragTargetChoosen;
        boolean dragToSide;
        int dragInsertPosition;

        private LayoutData() {
        }
    }
}

