/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentComboLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.ContentManagerEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

class ComboContentLayout
extends ContentLayout {
    BaseLabel myIdLabel;
    ContentComboLabel myComboLabel;

    ComboContentLayout(ToolWindowContentUi ui) {
        super(ui);
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false);
        this.myComboLabel = new ContentComboLabel(this);
    }

    @Override
    public void reset() {
        this.myIdLabel = null;
        this.myComboLabel = null;
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        Dimension idSize = this.myIdLabel.getPreferredSize();
        int eachX = 0;
        int eachY = 1;
        this.myIdLabel.setBounds(eachX, eachY, idSize.width, bounds.height);
        Dimension comboSize = this.myComboLabel.getPreferredSize();
        int spaceLeft = bounds.width - (eachX += idSize.width) - (this.isToDrawCombo() ? 3 : 0);
        int width = comboSize.width;
        if (width > spaceLeft) {
            width = spaceLeft;
        }
        this.myComboLabel.setBounds(eachX, eachY, width, bounds.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawCombo()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig c = new GraphicsConfig(g);
        c.setAntialiasing(true);
        this.fillTabShape(g2d, this.myComboLabel, this.getShapeFor(this.myComboLabel), true);
        c.restore();
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.isToDrawCombo()) {
            return;
        }
        GraphicsConfig c = new GraphicsConfig(g);
        c.setAntialiasing(true);
        Graphics2D g2d = (Graphics2D)g;
        Color edges = this.myUi.myWindow.isActive() ? TAB_BORDER_ACTIVE_WINDOW : TAB_BORDER_PASSIVE_WINDOW;
        g2d.setColor(edges);
        Shape shape = this.getShapeFor(this.myComboLabel);
        g2d.draw(shape);
        c.restore();
    }

    private Shape getShapeFor(ContentComboLabel label) {
        Rectangle bounds = label.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return new GeneralPath();
        }
        --bounds.y;
        int height = bounds.height - 1;
        ++bounds.width;
        int arc = 2;
        GeneralPath path = new GeneralPath();
        path.moveTo(bounds.x, bounds.y + height - arc);
        path.lineTo(bounds.x, bounds.y + arc);
        path.quadTo(bounds.x, bounds.y, bounds.x + arc, bounds.y);
        path.lineTo(bounds.x + bounds.width - arc, bounds.y);
        path.quadTo(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + arc);
        path.lineTo(bounds.x + bounds.width, bounds.y + height - arc);
        path.quadTo(bounds.x + bounds.width, bounds.y + height, bounds.x + bounds.width - arc, bounds.y + height);
        path.lineTo(bounds.x + arc, bounds.y + height);
        path.quadTo(bounds.x, bounds.y + height, bounds.x, bounds.y + height - arc);
        path.closePath();
        return path;
    }

    @Override
    public void update() {
        this.updateIdLabel(this.myIdLabel);
        this.myComboLabel.update();
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi);
        this.myUi.add(this.myComboLabel);
        ToolWindowContentUi.initMouseListeners(this.myComboLabel, this.myUi);
    }

    boolean isToDrawCombo() {
        return this.myUi.myManager.getContentCount() > 1;
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        listPopup.setMinimumSize(new Dimension(this.myComboLabel.getPreferredSize().width, 0));
        listPopup.showUnderneathOf((Component)this.myComboLabel);
    }
}

